/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekWdr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "WDR";
    private static final String ROCKPALAST_URL = "http://www1.wdr.de/fernsehen/kultur/rockpalast/videos/rockpalastvideos_konzerte100.html";
    private static final String ROCKPALAST_FESTIVAL = "http://www1.wdr.de/fernsehen/kultur/rockpalast/videos/rockpalastvideos_festivals100.html";
    private static final String MAUS = "http://www.wdrmaus.de/lachgeschichten/spots.php5";
    private static final String ELEFANT = "http://www.wdrmaus.de/elefantenseite/data/tableOfContents.php5";
    private final ArrayList<String> listeFestival = new ArrayList();
    private final ArrayList<String> listeRochpalast = new ArrayList();
    private final ArrayList<String> listeMaus = new ArrayList();
    private final ArrayList<String> listeElefant = new ArrayList();
    private final LinkedList<String> listeTage = new LinkedList();
    private MSStringBuilder seite_1 = new MSStringBuilder(65536);
    private MSStringBuilder seite_2 = new MSStringBuilder(65536);

    public MediathekWdr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 500, startPrio);
    }

    @Override
    public synchronized void addToList() {
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeFestival.clear();
        this.listeRochpalast.clear();
        this.listeMaus.clear();
        this.listeElefant.clear();
        this.meldungStart();
        this.addToList__();
        this.addTage();
        if (MSConfig.loadLongMax()) {
            // empty if block
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeTage.isEmpty() && this.listeFestival.isEmpty() && this.listeRochpalast.isEmpty() && this.listeMaus.isEmpty() && this.listeElefant.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size() + this.listeFestival.size() + this.listeRochpalast.size() + this.listeMaus.size() + this.listeElefant.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addTage() {
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyy");
        for (int i = 1; i < 14; ++i) {
            String URL2 = "http://www1.wdr.de/mediathek/video/sendungverpasst/sendung-verpasst-100~_tag-";
            String tag = formatter.format(new Date().getTime() - (long)(86400000 * i));
            String urlString = "http://www1.wdr.de/mediathek/video/sendungverpasst/sendung-verpasst-100~_tag-" + tag + ".html";
            this.listeTage.add(urlString);
        }
    }

    private void addToList__() {
        String URL2 = "http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html";
        String MUSTER_URL = "<a href=\"/mediathek/video/sendungen-a-z/";
        this.seite_1 = this.getUrlIo.getUri_Iso(SENDERNAME, "http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html", this.seite_1, "");
        this.themenSeitenSuchen("http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html");
        int pos1 = this.seite_1.indexOf("<strong>A</strong>");
        while (!MSConfig.getStop() && (pos1 = this.seite_1.indexOf("<a href=\"/mediathek/video/sendungen-a-z/", pos1)) != -1) {
            String url;
            int pos2 = this.seite_1.indexOf("\"", pos1 += "<a href=\"/mediathek/video/sendungen-a-z/".length());
            if (pos2 == -1 || (url = this.seite_1.substring(pos1, pos2)).equals("index.html")) continue;
            if (url.equals("")) {
                MSLog.fehlerMeldung(995122047, "keine URL");
                continue;
            }
            url = "http://www1.wdr.de/mediathek/video/sendungen-a-z/" + url;
            this.themenSeitenSuchen(url);
        }
    }

    private void themenSeitenSuchen(String strUrlFeed) {
        String MUSTER_URL = "<a href=\"/mediathek/video/sendungen/";
        int pos1 = 0;
        this.seite_2 = this.getUrlIo.getUri_Iso(SENDERNAME, strUrlFeed, this.seite_2, "");
        this.meldung(strUrlFeed);
        while (!MSConfig.getStop() && (pos1 = this.seite_2.indexOf("<a href=\"/mediathek/video/sendungen/", pos1)) != -1) {
            int pos2 = this.seite_2.indexOf("\"", pos1 += "<a href=\"/mediathek/video/sendungen/".length());
            if (pos2 != -1) {
                String url = this.seite_2.substring(pos1, pos2).trim();
                if (url.equals("")) continue;
                url = "http://www1.wdr.de/mediathek/video/sendungen/" + url;
                String[] add = new String[]{url, ""};
                this.listeThemen.addUrl(add);
                continue;
            }
            MSLog.fehlerMeldung(375862100, "keine Url" + strUrlFeed);
        }
    }

    private synchronized String getListeTage() {
        return this.listeTage.pollFirst();
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder sendungsSeite1;
        private MSStringBuilder sendungsSeite2;
        private MSStringBuilder sendungsSeite3;
        private MSStringBuilder sendungsSeite4;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekWdr.this.wartenSeiteLaden);
            this.sendungsSeite1 = new MSStringBuilder(65536);
            this.sendungsSeite2 = new MSStringBuilder(65536);
            this.sendungsSeite3 = new MSStringBuilder(65536);
            this.sendungsSeite4 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String url;
                String[] link;
                MediathekWdr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekWdr.this.listeThemen.getListeThemen()) != null) {
                    if (MediathekWdr.ROCKPALAST_URL.equals(link[0])) {
                        this.themenSeiteRockpalast();
                    } else if (MediathekWdr.ROCKPALAST_FESTIVAL.equals(link[0])) {
                        this.themenSeiteFestival();
                    } else if (MediathekWdr.MAUS.equals(link[0])) {
                        this.addFilmeMaus();
                    } else if (MediathekWdr.ELEFANT.equals(link[0])) {
                        this.addFilmeElefant();
                    } else {
                        this.sendungsSeitenSuchen1(link[0]);
                    }
                    MediathekWdr.this.meldungProgress(link[0]);
                }
                while (!MSConfig.getStop() && (url = MediathekWdr.this.getListeTage()) != null) {
                    MediathekWdr.this.meldungProgress(url);
                    this.sendungsSeitenSuchen2(url);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(633250489, ex);
            }
            MediathekWdr.this.meldungThreadUndFertig();
        }

        private void sendungsSeitenSuchen1(String strUrl) {
            String MUSTER_URL = "<a href=\"/mediathek/video/sendungen/";
            MediathekWdr.this.meldung(strUrl);
            this.sendungsSeitenSuchen2(strUrl);
            if (!MSConfig.loadLongMax()) {
                return;
            }
            this.sendungsSeite1 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, strUrl, this.sendungsSeite1, "");
            if (this.sendungsSeite1.length() == 0) {
                return;
            }
            int pos1 = this.sendungsSeite1.indexOf("<ul class=\"pageCounterNavi\">");
            if (pos1 == -1) {
                return;
            }
            int ende = this.sendungsSeite1.indexOf("</ul>", pos1);
            if (ende == -1) {
                return;
            }
            while ((pos1 = this.sendungsSeite1.indexOf("<a href=\"/mediathek/video/sendungen/", pos1)) != -1) {
                String urlWeiter;
                if ((pos1 += "<a href=\"/mediathek/video/sendungen/".length()) > ende) {
                    return;
                }
                int pos2 = this.sendungsSeite1.indexOf("\"", pos1 += "<a href=\"/mediathek/video/sendungen/".length());
                if (pos2 == -1 || (urlWeiter = this.sendungsSeite1.substring(pos1, pos2)).equals("")) continue;
                this.sendungsSeitenSuchen2("http://www1.wdr.de/mediathek/video/sendungen/" + urlWeiter);
            }
        }

        private void sendungsSeitenSuchen2(String strUrl) {
            String MUSTER_URL = "<div class=\"teaser hideTeasertext\">";
            int pos = 0;
            long duration = 0L;
            if (strUrl.startsWith("http://www1.wdr.de/mediathek/video/sendungen/lokalzeit/uebersicht-lokalzeiten100_tag")) {
                return;
            }
            this.sendungsSeite2 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, strUrl, this.sendungsSeite2, "");
            if (this.sendungsSeite2.length() == 0) {
                return;
            }
            MediathekWdr.this.meldung(strUrl);
            String thema = this.sendungsSeite2.extract("<title>", "<", pos);
            thema = thema.replace("- Sendung - Video - Mediathek - WDR", "").trim();
            if (thema.startsWith("Unser Sendungsarchiv")) {
                thema = "";
            }
            pos = 0;
            while (!MSConfig.getStop() && (pos = this.sendungsSeite2.indexOf("<div class=\"teaser hideTeasertext\">", pos)) != -1) {
                String url = this.sendungsSeite2.extract("<a href=\"/mediathek/video/sendungen/", "\"", pos += "<div class=\"teaser hideTeasertext\">".length());
                if (!url.equals("")) {
                    url = "http://www1.wdr.de/mediathek/video/sendungen/" + url;
                    String titel = this.sendungsSeite2.extract("<span class=\"hidden\">Video:</span>", "<", pos).trim();
                    titel = titel.replace("\n", "");
                    String datum = this.sendungsSeite2.extract("<p class=\"programInfo\">", "|", pos).trim();
                    String dauer = this.sendungsSeite2.extract("<span class=\"hidden\">L&auml;nge: </span>", "<", pos).trim();
                    try {
                        if (!dauer.equals("")) {
                            String[] parts = dauer.split(":");
                            duration = 0L;
                            long power = 1L;
                            for (int i = parts.length - 1; i >= 0; --i) {
                                duration += Long.parseLong(parts[i]) * power;
                                power *= 60L;
                            }
                        }
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(306597519, ex, strUrl);
                    }
                    this.addFilm1(thema, titel, url, duration, datum);
                    continue;
                }
                MSLog.fehlerMeldung(646432970, "keine Url" + strUrl);
            }
        }

        private void addFilm1(String thema, String titel, String filmWebsite, long dauer, String datum) {
            String url;
            MediathekWdr.this.meldung(filmWebsite);
            this.sendungsSeite3 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, filmWebsite, this.sendungsSeite3, "");
            if (this.sendungsSeite3.length() == 0) {
                return;
            }
            if (this.sendungsSeite3.length() == 0) {
                MSLog.fehlerMeldung(751236547, new String[]{"leere Seite: " + filmWebsite});
            }
            String description = this.sendungsSeite3.extract("<p class=\"text\">", "<");
            if (thema.isEmpty()) {
                thema = this.sendungsSeite3.extract("{ 'offset': '0' }}\" title=\"", "\"");
                if ((thema = thema.replace(", WDR", "")).contains(":")) {
                    thema = thema.substring(0, thema.indexOf(":"));
                }
                if (thema.contains(" -")) {
                    thema = thema.substring(0, thema.indexOf(" -"));
                }
            }
            if (!(url = this.sendungsSeite3.extract("mediaObj': { 'url': '", "'")).equals("")) {
                this.addFilm2(filmWebsite, thema, titel, url, dauer, datum, description);
            } else {
                MSLog.fehlerMeldung(763299001, new String[]{"keine Url: " + filmWebsite});
            }
        }

        private void addFilm2(String filmWebsite, String thema, String titel, String urlFilmSuchen, long dauer, String datum, String beschreibung) {
            String d;
            MediathekWdr.this.meldung(urlFilmSuchen);
            this.sendungsSeite4 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, urlFilmSuchen, this.sendungsSeite4, "");
            if (this.sendungsSeite4.length() == 0) {
                return;
            }
            String urlMax = "";
            String urlKlein = "";
            String zeit = "";
            String url = this.sendungsSeite4.extract("\"alt\":{\"videoURL\":\"", "\"");
            String f4m = this.sendungsSeite4.extract("\"dflt\":{\"videoURL\":\"", "\"");
            if (!f4m.isEmpty() && url.contains("_") && url.endsWith(".mp4")) {
                String s1 = url.substring(url.lastIndexOf("_") + 1, url.indexOf(".mp4"));
                String s2 = url.substring(0, url.lastIndexOf("_") + 1);
                try {
                    int nr = Integer.parseInt(s1);
                    if (f4m.contains(nr + 2 + "")) {
                        urlMax = s2 + (nr + 2) + ".mp4";
                    }
                    if (f4m.contains(nr + 4 + "")) {
                        urlKlein = s2 + (nr + 4) + ".mp4";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!urlMax.isEmpty()) {
                    if (urlKlein.isEmpty()) {
                        urlKlein = url;
                    }
                    url = urlMax;
                }
            } else {
                System.out.println("nix");
            }
            if (titel.isEmpty()) {
                titel = this.sendungsSeite4.extract("\"trackerClipTitle\":\"", "\"");
            }
            String subtitle = this.sendungsSeite4.extract("\"captionURL\":\"", "\"");
            if (datum.isEmpty()) {
                d = this.sendungsSeite4.extract("\"trackerClipAirTime\":\"", "\"");
                if (d.contains(" ")) {
                    zeit = d.substring(d.indexOf(" ")) + ":00";
                    datum = d.substring(0, d.indexOf(" "));
                }
            } else {
                d = this.sendungsSeite4.extract("\"trackerClipAirTime\":\"", "\"");
                if (d.contains(" ")) {
                    zeit = d.substring(d.indexOf(" ")) + ":00";
                } else {
                    System.out.println("Zeit");
                }
            }
            if (!url.isEmpty()) {
                DatenFilm film = new DatenFilm(MediathekWdr.SENDERNAME, thema, filmWebsite, titel, url, "", datum, zeit, dauer, beschreibung);
                if (!subtitle.isEmpty()) {
                    film.addUrlSubtitle(subtitle);
                }
                if (!urlKlein.isEmpty()) {
                    film.addUrlKlein(urlKlein, "");
                }
                MediathekWdr.this.addFilm(film);
            } else {
                MSLog.fehlerMeldung(978451239, new String[]{"keine Url: " + urlFilmSuchen, "UrlThema: " + filmWebsite});
            }
        }

        private void themenSeiteRockpalast() {
            try {
                for (String s : MediathekWdr.this.listeRochpalast) {
                    MediathekWdr.this.meldungProgress(s);
                    if (!MSConfig.getStop()) {
                        if (s.endsWith("/fernsehen/kultur/rockpalast/videos/index.html") || s.contains("/fernsehen/kultur/rockpalast/videos/uebersicht_Konzerte10")) continue;
                        this.addFilmeRockpalast(s, "Rockpalast");
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(696963025, ex);
            }
        }

        private void themenSeiteFestival() {
            try {
                for (String s : MediathekWdr.this.listeFestival) {
                    MediathekWdr.this.meldungProgress(s);
                    if (!MSConfig.getStop()) {
                        if (s.endsWith("/fernsehen/kultur/rockpalast/videos/index.html") || s.contains("/fernsehen/kultur/rockpalast/videos/uebersicht_Festivals116.html") || s.endsWith("/uebersicht_Festival100.html") || s.endsWith("/uebersicht_Festivals100.html")) continue;
                        this.addFilmeRockpalast(s, "Rockpalast - Festival");
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915263698, ex);
            }
        }

        private void addFilmeMaus() {
            try {
                for (String filmWebsite : MediathekWdr.this.listeMaus) {
                    MediathekWdr.this.meldungProgress(filmWebsite);
                    if (!MSConfig.getStop()) {
                        this.sendungsSeite1 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, filmWebsite, this.sendungsSeite1, "");
                        String titel = this.sendungsSeite1.extract("<title>", "<");
                        if ((titel = titel.replace("\n", "")).contains("-")) {
                            titel = titel.substring(0, titel.indexOf("-")).trim();
                        }
                        String description = this.sendungsSeite1.extract("<div class=\"videotext\">", "<");
                        String datum = this.sendungsSeite1.extract("<div class=\"sendedatum\"><p>Sendedatum: ", "<").trim();
                        String url = this.sendungsSeite1.extract("firstVideo=rtmp://", ".mp4");
                        if (url.isEmpty()) {
                            MSLog.fehlerMeldung(730215698, "keine URL: " + filmWebsite);
                            continue;
                        }
                        url = "http://http-ras.wdr.de/CMS2010/mdb" + url.substring(url.indexOf("/ondemand/")) + ".mp4";
                        DatenFilm film = new DatenFilm(MediathekWdr.SENDERNAME, "MausSpots", filmWebsite, titel, url, "", datum, "", 0L, description);
                        MediathekWdr.this.addFilm(film);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915263698, ex);
            }
        }

        private void addFilmeElefant() {
            try {
                for (String filmWebsite : MediathekWdr.this.listeElefant) {
                    MediathekWdr.this.meldungProgress(filmWebsite);
                    if (MSConfig.getStop()) break;
                    this.sendungsSeite1 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, filmWebsite, this.sendungsSeite1, "");
                    long duration = 0L;
                    String titel = this.sendungsSeite1.extract("<title><![CDATA[", "]");
                    String description = this.sendungsSeite1.extract("<text><![CDATA[", "]");
                    String datum = this.sendungsSeite1.extract("<sendedatum><![CDATA[", "]");
                    if (datum.isEmpty()) {
                        datum = this.sendungsSeite1.extract("<pubstart><![CDATA[", "]");
                    }
                    try {
                        SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                        datum = sdfOut.format(sdfIn.parse(datum));
                    }
                    catch (Exception ex) {
                        datum = "";
                        MSLog.fehlerMeldung(945214787, "kein Datum");
                    }
                    String d = this.sendungsSeite1.extract("<duration><![CDATA[", "]");
                    try {
                        if (!d.equals("")) {
                            duration = Long.parseLong(d);
                        }
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(732659874, ex, "duration: " + d);
                    }
                    String url = this.sendungsSeite1.extract("<file_xl><![CDATA[", "]");
                    String urlKlein = this.sendungsSeite1.extract("<file><![CDATA[", "]");
                    if (url.isEmpty()) {
                        url = urlKlein;
                        urlKlein = "";
                    }
                    if (url.isEmpty()) {
                        MSLog.fehlerMeldung(632012541, "keine URL: " + filmWebsite);
                        continue;
                    }
                    url = "http://http-ras.wdr.de/mediendb/elefant_online" + url;
                    DatenFilm film = new DatenFilm(MediathekWdr.SENDERNAME, "Elefantenkino", "http://www.wdrmaus.de/elefantenseite/", titel, url, "", datum, "", duration, description);
                    if (!urlKlein.isEmpty()) {
                        urlKlein = "http://http-ras.wdr.de/mediendb/elefant_online/" + urlKlein;
                        film.addUrlKlein(urlKlein, "");
                    }
                    MediathekWdr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(747586936, ex);
            }
        }

        private void addFilmeRockpalast(String filmWebsite, String thema) {
            String url;
            MediathekWdr.this.meldung(filmWebsite);
            this.sendungsSeite1 = this.getUrl.getUri_Utf(MediathekWdr.SENDERNAME, filmWebsite, this.sendungsSeite1, "");
            long duration = 0L;
            String titel = this.sendungsSeite1.extract("headline: \"", "\"");
            titel = titel.replace("\n", "");
            String d = this.sendungsSeite1.extract("length: \"(", ")");
            try {
                if (!d.equals("") && d.length() <= 8 && d.contains(":")) {
                    String[] parts = d.split(":");
                    long power = 1L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        duration += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915263625, ex, "duration: " + d);
            }
            String description = this.sendungsSeite1.extract("<meta name=\"Description\" content=\"", "\"");
            String datum = this.sendungsSeite1.extract("Konzert vom", "\"").trim();
            if (datum.isEmpty()) {
                datum = this.sendungsSeite1.extract("Sendung vom ", "\"").trim();
            }
            if ((url = this.sendungsSeite1.extract("<a href=\"/fernsehen/kultur/rockpalast/videos/av/", "\"")).isEmpty()) {
                MSLog.fehlerMeldung(915236547, "keine URL: " + filmWebsite);
            } else {
                url = "http://www1.wdr.de/fernsehen/kultur/rockpalast/videos/av/" + url;
                this.addFilm2(filmWebsite, thema, titel, url, duration, datum, description);
            }
        }
    }
}

