/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekBr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "BR";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm", Locale.ENGLISH);
    private final SimpleDateFormat sdfOutTime = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat sdfOutDay = new SimpleDateFormat("dd.MM.yyyy");
    private final MediathekReader.LinkedListUrl listeTage = new MediathekReader.LinkedListUrl(this);
    private static final String PATTERN_VERY_SMALL = "<asset type=\"STANDARD\">";
    private static final String PATTERN_SMALL = "<asset type=\"LARGE\">";
    private static final String PATTERN_NORMAL = "<asset type=\"PREMIUM\">";
    private static final String PATTERN_HD = "<asset type=\"HD\">";
    private static final String PATTERN_DLURL = "<downloadUrl>";
    private static final String PATTERN_END = "<";
    LinkedList<String> listeAlleThemen = new LinkedList();
    LinkedList<String> listeAlleThemenCount = new LinkedList();
    LinkedList<String> listeAlleThemenCount_ = new LinkedList();

    public MediathekBr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 1000, startPrio);
    }

    @Override
    void addToList() {
        this.mSearchFilmeSuchen.listeFilmeAlt.getThema(this.sendername, this.listeAlleThemenCount_);
        this.meldungStart();
        this.getTheman();
        this.getTage();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeTage.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            Thread thArchiv;
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size());
            if (MSConfig.loadLongMax()) {
                thArchiv = new Thread(new ArchivLaden(1, 50));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(51, 100));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(101, 150));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(151, 200));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
            }
            if (MSConfig.loadMax()) {
                thArchiv = new Thread(new ArchivLaden(201, 250));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(251, 300));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(301, 350));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
                thArchiv = new Thread(new ArchivLaden(351, 400));
                thArchiv.setName(SENDERNAME);
                thArchiv.start();
            }
            new Thread((Runnable)new KlassikLaden(), SENDERNAME).start();
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void getTheman() {
        String ADRESSE = "http://www.br.de/mediathek/video/sendungen/index.html";
        String MUSTER_URL = "<a href=\"/mediathek/video/";
        String MUSTER_URL_1 = "sendungen/";
        String MUSTER_URL_2 = "video/";
        this.listeThemen.clear();
        MSStringBuilder seite = new MSStringBuilder(65536);
        seite = this.getUrlIo.getUri(SENDERNAME, "http://www.br.de/mediathek/video/sendungen/index.html", "UTF-8", 5, seite, "");
        int pos1 = 0;
        String url = "";
        pos1 = seite.indexOf("<ul class=\"clearFix\">");
        if (pos1 != -1) {
            while ((pos1 = seite.indexOf("<a href=\"/mediathek/video/", pos1)) != -1 && !MSConfig.getStop()) {
                try {
                    int pos2 = seite.indexOf("\"", pos1 += "<a href=\"/mediathek/video/".length());
                    if (pos2 != -1) {
                        url = seite.substring(pos1, pos2);
                    }
                    String thema = seite.extract("<span>", PATTERN_END, pos1);
                    thema = StringEscapeUtils.unescapeXml(thema.trim());
                    if (!this.listeAlleThemen.contains(thema = StringEscapeUtils.unescapeHtml4(thema.trim()))) {
                        this.listeAlleThemen.add(thema);
                    }
                    if (url.equals("") || !url.startsWith("sendungen/") && !url.startsWith("video/")) continue;
                    String[] add = new String[]{"http://www.br.de/mediathek/video/" + url, thema};
                    this.listeThemen.addUrl(add);
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(821213698, ex);
                }
            }
        }
    }

    private void getTage() {
        String ADRESSE = "http://www.br.de/mediathek/video/programm/index.html";
        String MUSTER = "http://www.br.de/mediathek/video/programm/mediathek-programm-100~_date-";
        this.listeTage.clear();
        MSStringBuilder seite1 = new MSStringBuilder(65536);
        MSStringBuilder seite2 = new MSStringBuilder(65536);
        ArrayList<String> al = new ArrayList<String>();
        try {
            seite1 = this.getUrlIo.getUri(SENDERNAME, "http://www.br.de/mediathek/video/programm/index.html", "UTF-8", 5, seite1, "");
            int max_ = MSConfig.loadLongMax() ? 21 : 7;
            for (int i = 0; i < max_ && !MSConfig.getStop(); ++i) {
                String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime() - (long)(i * 86400000));
                String url = seite1.extract("/mediathek/video/programm/mediathek-programm-100~_date-" + date, "\"");
                if (url.equals("")) continue;
                url = "http://www.br.de/mediathek/video/programm/mediathek-programm-100~_date-" + date + url;
                seite2 = this.getUrlIo.getUri_Utf(SENDERNAME, url, seite2, "");
                seite2.extractList("<div class=\"epgContainer\"", "<h3>Legende</h3>", "<a href=\"/mediathek/video/", "\"", "http://www.br.de/mediathek/video/", al);
            }
            for (String s : al) {
                String[] add = new String[]{s, ""};
                if (this.istInListe(this.listeTage, add[0], 0)) continue;
                this.listeTage.add(add);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(821213698, ex);
        }
    }

    @Override
    synchronized void meldungThreadUndFertig() {
        if (this.threads <= 1) {
            this.mSearchFilmeSuchen.listeFilmeNeu.checkThema(this.sendername, this.listeAlleThemenCount_, this.sendername);
        }
        super.meldungThreadUndFertig();
    }

    private void loadXml(MSStringBuilder seite, String urlXml, String urlThema, String thema, String titel, String description, String datum, String zeit) {
        long duration = 0L;
        if ((seite = this.getUrlIo.getUri_Utf(SENDERNAME, urlXml, seite, "")).length() == 0) {
            MSLog.fehlerMeldung(820139701, urlXml);
            return;
        }
        try {
            String dauer = seite.extract("<duration>", PATTERN_END);
            if (!dauer.equals("")) {
                String[] parts = dauer.split(":");
                duration = 0L;
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    duration += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
        }
        catch (NumberFormatException ex) {
            MSLog.fehlerMeldung(735216703, (Exception)ex, urlThema);
        }
        if (description.isEmpty()) {
            description = seite.extract("<desc>", "</desc>");
        }
        String subtitle = seite.extract("<dataTimedText url=\"", "\"");
        String urlVerySmall = this.getUrl(seite, PATTERN_VERY_SMALL);
        String urlSmall = this.getUrl(seite, PATTERN_SMALL);
        String urlNormal = this.getUrl(seite, PATTERN_NORMAL);
        String urlHd = this.getUrl(seite, PATTERN_HD);
        if (urlHd.isEmpty()) {
            // empty if block
        }
        if (urlNormal.isEmpty()) {
            if (!urlSmall.isEmpty()) {
                urlNormal = urlSmall;
                urlSmall = "";
            } else if (!urlVerySmall.isEmpty()) {
                urlNormal = urlVerySmall;
                urlVerySmall = "";
            }
        }
        if (urlVerySmall.isEmpty()) {
            urlVerySmall = urlSmall;
        }
        if (!urlNormal.isEmpty()) {
            if (thema.equals(SENDERNAME) && (thema = seite.extract("<broadcast>", PATTERN_END)).equals(titel)) {
                titel = seite.extract("<title>", PATTERN_END);
            }
            if (!thema.isEmpty()) {
                if (!this.listeAlleThemenCount.contains(thema)) {
                    this.listeAlleThemenCount.add(thema);
                } else if (!this.listeAlleThemenCount_.contains(thema)) {
                    this.listeAlleThemenCount_.add(thema);
                }
            }
            DatenFilm film = new DatenFilm(SENDERNAME, thema, urlThema, titel, urlNormal, "", datum, zeit, duration, description);
            if (!urlVerySmall.isEmpty()) {
                film.addUrlKlein(urlVerySmall, "");
            }
            if (!urlHd.isEmpty()) {
                film.addUrlHd(urlHd, "");
            }
            if (!subtitle.isEmpty()) {
                subtitle = "http://www.br.de" + subtitle;
                film.addUrlSubtitle(subtitle);
            }
            this.addFilm(film);
            this.meldung(film.arr[12]);
        } else {
            MSLog.fehlerMeldung(612136978, "keine URL: " + urlXml);
        }
    }

    private String getUrl(MSStringBuilder seiteXml, String pattern) {
        return seiteXml.extract(pattern, PATTERN_DLURL, PATTERN_END);
    }

    private String checkThema(String thema) {
        thema = StringEscapeUtils.unescapeXml(thema.trim());
        thema = StringEscapeUtils.unescapeHtml4(thema.trim());
        for (String s : this.listeAlleThemen) {
            if (!thema.equalsIgnoreCase(s)) continue;
            return s;
        }
        for (String s : this.listeAlleThemen) {
            if (!thema.toLowerCase().startsWith(s.toLowerCase())) continue;
            return s;
        }
        return this.sendername;
    }

    private class ArchivLaden
    implements Runnable {
        int anfang;
        int ende;
        private MSStringBuilder seiteXml = new MSStringBuilder(65536);

        public ArchivLaden(int aanfang, int eende) {
            this.anfang = aanfang;
            this.ende = eende;
        }

        @Override
        public synchronized void run() {
            MediathekBr.this.meldungAddMax(this.ende - this.anfang);
            MediathekBr.this.meldungAddThread();
            try {
                this.archivSuchen(this.anfang, this.ende);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(203069877, ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        private void archivSuchen(int start, int ende) {
            String MUSTER_ADRESSE_1 = "http://www.br.de/service/suche/archiv102.html?documentTypes=video&page=";
            String MUSTER_ADRESSE_2 = "&sort=date";
            String MUSTER_START = "<div class=\"teaser search_result\">";
            MSStringBuilder seiteArchiv1 = new MSStringBuilder(65536);
            MSStringBuilder seiteArchiv2 = new MSStringBuilder(65536);
            MSGetUrl getUrl = new MSGetUrl(MediathekBr.this.wartenSeiteLaden);
            for (int i = start; i <= ende && !MSConfig.getStop(); ++i) {
                String adresse = "http://www.br.de/service/suche/archiv102.html?documentTypes=video&page=" + i + "&sort=date";
                MediathekBr.this.meldungProgress(adresse);
                seiteArchiv1 = getUrl.getUri(MediathekBr.SENDERNAME, adresse, "UTF-8", 2, seiteArchiv1, "");
                if (seiteArchiv1.length() == 0) {
                    // empty if block
                }
                int pos = 0;
                while (!MSConfig.getStop() && (pos = seiteArchiv1.indexOf("<div class=\"teaser search_result\">", pos)) != -1) {
                    int stop = seiteArchiv1.indexOf("<div class=\"teaser search_result\">", pos += "<div class=\"teaser search_result\">".length());
                    String url = seiteArchiv1.extract("<a href=\"", "\"", pos, stop);
                    String thema = seiteArchiv1.extract("teaser_overline\">", MediathekBr.PATTERN_END, pos, stop).trim();
                    if (thema.endsWith(":")) {
                        thema = thema.substring(0, thema.lastIndexOf(":"));
                    }
                    thema = MediathekBr.this.checkThema(thema);
                    String titel = seiteArchiv1.extract("teaser_title\">", MediathekBr.PATTERN_END, pos, stop);
                    String datum = seiteArchiv1.extract("search_date\">", MediathekBr.PATTERN_END, pos, stop);
                    if (datum.contains("|")) {
                        datum = datum.substring(0, datum.indexOf("|")).trim();
                    }
                    String beschreibung = seiteArchiv1.extract("<p>", MediathekBr.PATTERN_END, pos, stop);
                    if (url.equals("")) continue;
                    url = "http://www.br.de" + url;
                    this.archivAdd1(getUrl, seiteArchiv2, url, thema, titel, datum, beschreibung);
                }
            }
        }

        private void archivAdd1(MSGetUrl getUrl, MSStringBuilder seiteArchiv2, String urlThema, String thema, String titel, String datum, String beschreibung) {
            MediathekBr.this.meldung(urlThema);
            seiteArchiv2 = getUrl.getUri(MediathekBr.SENDERNAME, urlThema, "UTF-8", 1, seiteArchiv2, "");
            if (seiteArchiv2.length() == 0) {
                // empty if block
            }
            String urlFilm = "";
            String urlFilmKlein = "";
            String groesse = "";
            String duration = "";
            long dauer = 0L;
            String xmlUrl = seiteArchiv2.extract("setup({dataURL:'", "'");
            if (beschreibung.isEmpty()) {
                beschreibung = seiteArchiv2.extract("<meta property=\"og:description\" content=\"", "\"");
            }
            if (beschreibung.isEmpty()) {
                beschreibung = seiteArchiv2.extract("<div class=\"bcastContent\">", "<p>", "</p>");
            }
            if (!xmlUrl.equals("")) {
                xmlUrl = "http://www.br.de" + xmlUrl;
                MediathekBr.this.loadXml(this.seiteXml, xmlUrl, urlThema, thema, titel, beschreibung, datum, "");
            }
        }
    }

    private class KlassikLaden
    implements Runnable {
        MSGetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite2;
        private final MSStringBuilder seite3;
        private final MSStringBuilder seiteXml;

        private KlassikLaden() {
            this.getUrl = new MSGetUrl(MediathekBr.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.seiteXml = new MSStringBuilder(65536);
        }

        @Override
        public synchronized void run() {
            try {
                MediathekBr.this.meldungAddThread();
                this.laden();
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(954123458, ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        void laden() {
            MSStringBuilder seite = this.seite1;
            MediathekBr.this.getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, "http://www.br.de/mediathek/video/br-klassik-mediathek-100.html", seite, "");
            if (seite.length() == 0) {
                return;
            }
            String thema = "BR-Klassik";
            String zeit = "";
            String u = seite.extract("<a class=\"button large\" href=\"", "\"");
            if (!u.isEmpty()) {
                u = "http://www.br.de" + u;
                MediathekBr.this.getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, u, this.seite2, "");
                if (this.seite2.length() != 0) {
                    seite = this.seite2;
                }
            }
            ArrayList<String> result = new ArrayList<String>();
            seite.extractList("<h2 id=\"inhalt\" class=\"hidden\">Inhalt</h2>", "<div class=\"teaserBundleMore\">", "<a href=\"/mediathek/video/", "\"", "http://www.br.de/mediathek/video/", result);
            MediathekBr.this.meldungAddMax(result.size());
            int count = 0;
            for (String url : result) {
                if (MSConfig.getStop() || !MSConfig.loadLongMax() && ++count > 20) break;
                MediathekBr.this.meldungProgress(url);
                MediathekBr.this.getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, url, this.seite3, url);
                String titel = this.seite3.extract("<h3>", MediathekBr.PATTERN_END);
                String datum = this.seite3.extract("<time class=\"start\" datetime=\"", ">", MediathekBr.PATTERN_END);
                datum = datum.replace("Uhr", "").trim();
                if (!datum.isEmpty()) {
                    zeit = this.convertTime(datum);
                    datum = this.convertDatum(datum);
                }
                String description1 = this.seite3.extract("<li class=\"title\">", MediathekBr.PATTERN_END);
                description1 = description1 + "\n";
                String description2 = this.seite3.extract("<div class=\"bcastContent\">", "</p>");
                description2 = description2.replaceFirst("\n", "");
                description2 = description2.replaceFirst("<p>", "");
                description2 = description2.replaceAll("<br/>", "\n");
                String urlXml = this.seite3.extract("{dataURL:'", "'");
                if (urlXml.isEmpty()) {
                    MSLog.fehlerMeldung(815263987, "keine URL: " + url);
                    continue;
                }
                urlXml = "http://www.br.de" + urlXml;
                MediathekBr.this.loadXml(this.seiteXml, urlXml, url, "BR-Klassik", titel, description1 + description2, datum, zeit);
            }
        }

        private String convertDatum(String datum) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(datum);
                datum = MediathekBr.this.sdfOutDay.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(915364789, (Exception)ex, "Datum: " + datum);
            }
            return datum;
        }

        private String convertTime(String zeit) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(zeit);
                zeit = MediathekBr.this.sdfOutTime.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(312154879, (Exception)ex, "Time: " + zeit);
            }
            return zeit;
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private MSStringBuilder seiteXml;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekBr.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.seiteXml = new MSStringBuilder(65536);
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekBr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekBr.this.listeThemen.getListeThemen()) != null) {
                    MediathekBr.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], this.seite1, true);
                }
                while (!MSConfig.getStop() && (link = MediathekBr.this.listeTage.getListeThemen()) != null) {
                    MediathekBr.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], this.seite1, false);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(989632147, ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        void laden(String urlThema, String thema, MSStringBuilder seite, boolean weitersuchen) {
            String urlXml;
            String description;
            String urlSeite;
            if ((seite = MediathekBr.this.getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, urlThema, seite, "")).length() == 0) {
                return;
            }
            String zeit = "";
            if (seite.indexOf("<p class=\"noVideo\">Zur Sendung \"") != -1 && seite.indexOf("\" liegen momentan keine Videos vor</p>") != -1) {
                return;
            }
            String thema_ = seite.extract("<h3>", MediathekBr.PATTERN_END).trim();
            if (thema.isEmpty()) {
                thema = MediathekBr.this.checkThema(thema_);
            }
            String titel = !thema.equals(thema_) ? thema_ : seite.extract("<li class=\"title\">", MediathekBr.PATTERN_END);
            String datum = seite.extract("<time class=\"start\" datetime=\"", ">", MediathekBr.PATTERN_END);
            if (!(datum = datum.replace("Uhr", "").trim()).isEmpty()) {
                zeit = this.convertTime(datum);
                datum = this.convertDatum(datum);
            }
            if ((urlSeite = seite.extract("id=\"fieldLink\" value=\"", "\"")).isEmpty()) {
                MSLog.fehlerMeldung(912030145, "urlSeite leer: " + urlThema);
                urlSeite = urlThema;
            }
            if ((description = seite.extract("<meta property=\"og:description\" content=\"", "\"")).isEmpty()) {
                description = seite.extract("<div class=\"bcastContent\">", "<p>", "</p>");
            }
            if ((urlXml = seite.extract("{dataURL:'", "'")).isEmpty()) {
                MSLog.fehlerMeldung(915263478, "keine URL: " + urlThema);
            } else {
                urlXml = "http://www.br.de" + urlXml;
                MediathekBr.this.loadXml(this.seiteXml, urlXml, urlSeite, thema, titel, description, datum, zeit);
            }
            if (!weitersuchen) {
                return;
            }
            int count = 0;
            int max = MSConfig.loadLongMax() ? 20 : 0;
            String STOP = "<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>";
            int stop = seite.indexOf("<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>");
            if (max > 0) {
                String u;
                if (urlThema.equals("http://www.br.de/mediathek/video/sendungen/spielfilme-im-br/spielfilme-im-br110.html") || urlThema.equals("http://www.br.de/mediathek/video/sendungen/alpha-centauri/alpha-centauri104.html")) {
                    max = 60;
                }
                if (!(u = seite.extract("<a class=\"button large\" href=\"", "\"", 0, stop)).isEmpty()) {
                    u = "http://www.br.de" + u;
                    this.seite3 = MediathekBr.this.getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, u, seite, "");
                    if (this.seite3.length() != 0) {
                        seite = this.seite3;
                        stop = seite.indexOf("<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>");
                    }
                }
            }
            String MUSTER_URL = "<a href=\"/mediathek/video/";
            int pos1 = seite.indexOf("<h3>Mehr von <strong>");
            if (pos1 != -1) {
                while (!(MSConfig.getStop() || (pos1 = seite.indexOf("<a href=\"/mediathek/video/", pos1)) == -1 || stop > 0 && pos1 > stop)) {
                    String urlWeiter = seite.extract("<a href=\"/mediathek/video/", "\"", pos1);
                    pos1 += "<a href=\"/mediathek/video/".length();
                    if (urlWeiter.isEmpty() || (urlWeiter = "http://www.br.de/mediathek/video/" + urlWeiter).contains("livestream")) continue;
                    if (++count > max) break;
                    this.laden(urlWeiter, thema, this.seite2, false);
                }
            }
        }

        private String convertDatum(String datum) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(datum);
                datum = MediathekBr.this.sdfOutDay.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(915364789, (Exception)ex, "Datum: " + datum);
            }
            return datum;
        }

        private String convertTime(String zeit) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(zeit);
                zeit = MediathekBr.this.sdfOutTime.format(filmDate);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(312154879, (Exception)ex, "Time: " + zeit);
            }
            return zeit;
        }
    }
}

