/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSRunSender;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MSGetUrl {
    public static boolean showLoadTime = false;
    private static final long UrlWartenBasis = 500L;
    private final int WARTEN_NO_BUFFER = 2000;
    private int timeout = 10000;
    private long wartenBasis = 500L;
    public static final int LADE_ART_NIX = 1;
    public static final int LADE_ART_DEFLATE = 2;
    public static final int LADE_ART_GZIP = 3;
    static final Lock lock = new ReentrantLock();

    public MSGetUrl(long wwartenBasis) {
        this.wartenBasis = wwartenBasis;
    }

    public MSStringBuilder getUri_Utf(String sender, String addr, MSStringBuilder seite, String meldung) {
        return this.getUri(sender, addr, "UTF-8", 1, seite, meldung);
    }

    public MSStringBuilder getUri_Iso(String sender, String addr, MSStringBuilder seite, String meldung) {
        return this.getUri(sender, addr, "ISO-8859-15", 1, seite, meldung);
    }

    public synchronized MSStringBuilder getUri(String sender, String addr, String kodierung, int maxVersuche, MSStringBuilder seite, String meldung) {
        int PAUSE = 1000;
        int aktTimeout = this.timeout;
        int aktVer = 0;
        do {
            ++aktVer;
            try {
                boolean letzterVersuch;
                if (aktVer > 1) {
                    this.wait(1000L);
                }
                if ((seite = this.getUri(sender, addr, seite, kodierung, aktTimeout, meldung, maxVersuche, letzterVersuch = aktVer >= maxVersuche)).length() > 0) {
                    if (MSConfig.debug && aktVer > 1) {
                        String text = sender + " [" + aktVer + "/" + maxVersuche + "] ~~~> " + addr;
                        MSLog.systemMeldung(text);
                    }
                    MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.ANZAHL);
                    return seite;
                }
                int wartezeit = aktVer > 1 ? aktTimeout + 1000 : aktTimeout;
                MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.FEHLVERSUCHE);
                MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.WARTEZEIT_FEHLVERSUCHE.ordinal(), this.wartenBasis);
                if (!letzterVersuch) continue;
                MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.FEHLER);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(698963200, ex, sender);
            }
        } while (!MSConfig.getStop() && aktVer < maxVersuche);
        return seite;
    }

    public void setTimeout(int ttimeout) {
        this.timeout = ttimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized MSStringBuilder getUri(String sender, String addr, MSStringBuilder seite, String kodierung, int timeout, String meldung, int versuch, boolean lVersuch) {
        seite.setLength(0);
        HttpURLConnection conn = null;
        InputStream in = null;
        InputStreamReader inReader = null;
        MVInputStream mvIn = null;
        Date start = null;
        Date stop = null;
        if (showLoadTime) {
            start = new Date();
        }
        try {
            this.wait(this.wartenBasis);
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(976120379, ex, sender);
        }
        try {
            int n;
            int ladeArt;
            Object saddr;
            conn = (HttpURLConnection)new URL(addr).openConnection();
            conn.setRequestProperty("User-Agent", MSConfig.getUserAgent());
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            if (timeout > 0) {
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
            }
            String encoding = conn.getContentEncoding();
            int retCode = conn.getResponseCode();
            if (retCode < 400) {
                mvIn = new MVInputStream(conn);
            } else if (retCode == 403 || retCode == 408) {
                if (!MSConfig.proxyUrl.isEmpty() && MSConfig.proxyPort > 0) {
                    saddr = new InetSocketAddress(MSConfig.proxyUrl, MSConfig.proxyPort);
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, (SocketAddress)saddr);
                    conn = (HttpURLConnection)new URL(addr).openConnection(proxy);
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:25.0) Gecko/20100101 Firefox/25.0");
                    conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                    if (timeout > 0) {
                        conn.setReadTimeout(timeout);
                        conn.setConnectTimeout(timeout);
                    }
                    encoding = conn.getContentEncoding();
                    mvIn = new MVInputStream(conn);
                    MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.PROXY);
                }
            } else {
                MSLog.fehlerMeldung(974532107, new String[]{"HTTP-Fehlercode: " + retCode, "Sender: " + sender, "URL: " + addr});
            }
            if (mvIn == null) {
                saddr = seite;
                return saddr;
            }
            if (mvIn.getInputStream() == null) {
                saddr = seite;
                return saddr;
            }
            if (encoding == null) {
                ladeArt = 1;
                in = mvIn;
            } else if (encoding.equalsIgnoreCase("gzip")) {
                ladeArt = 3;
                in = new GZIPInputStream(mvIn);
            } else if (encoding.equalsIgnoreCase("deflate")) {
                ladeArt = 2;
                in = new InflaterInputStream(mvIn, new Inflater(true));
            } else {
                ladeArt = 1;
                in = mvIn;
            }
            inReader = new InputStreamReader(in, kodierung);
            char[] buffer = new char[1024];
            long load = 0L;
            while (!MSConfig.getStop() && (n = inReader.read(buffer)) != -1) {
                seite.append(buffer, 0, n);
                load += (long)n;
            }
            if (showLoadTime) {
                stop = new Date();
                if (start != null) {
                    long diff = stop.getTime() - start.getTime();
                    System.out.println("\nDauer: " + diff / 1000L + "," + diff % 1000L);
                }
            }
            MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.SUM_DATA_BYTE.ordinal(), load);
            MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.SUM_TRAFFIC_BYTE.ordinal(), mvIn.summe);
            switch (ladeArt) {
                case 1: {
                    MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.SUM_TRAFFIC_LOADART_NIX.ordinal(), mvIn.summe);
                    return seite;
                }
                case 2: {
                    MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.SUM_TRAFFIC_LOADART_DEFLATE.ordinal(), mvIn.summe);
                    return seite;
                }
                case 3: {
                    MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.SUM_TRAFFIC_LOADART_GZIP.ordinal(), mvIn.summe);
                    return seite;
                }
            }
            return seite;
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    InputStream i = conn.getErrorStream();
                    if (i != null) {
                        i.close();
                    }
                    if (inReader != null) {
                        inReader.close();
                    }
                }
                catch (Exception e) {
                    MSLog.fehlerMeldung(645105987, e, "");
                }
            }
            if (!lVersuch) return seite;
            String[] text = meldung.equals("") ? new String[]{"", "Sender: " + sender + " - timout: " + timeout + " Versuche: " + versuch, "URL: " + addr} : new String[]{"", "Sender: " + sender + " - timout: " + timeout + " Versuche: " + versuch, "URL: " + addr, meldung};
            switch (ex.getMessage()) {
                case "Read timed out": {
                    text[0] = "TimeOut: ";
                    MSLog.fehlerMeldung(502739817, text);
                    return seite;
                }
                case "No buffer space available": {
                    text[0] = "No buffer space available";
                    MSLog.fehlerMeldung(915263697, text);
                    try {
                        this.wait(2000L);
                        MSFilmeSuchen.listeSenderLaufen.inc(sender, MSRunSender.Count.NO_BUFFER);
                        return seite;
                    }
                    catch (Exception exception) {
                        return seite;
                    }
                }
            }
            MSLog.fehlerMeldung(379861049, (Exception)ex, text);
            return seite;
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(973969801, ex, "");
            return seite;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(696321478, ex, "");
            }
        }
    }

    private class MVInputStream
    extends InputStream {
        InputStream in = null;
        long summe = 0L;
        int nr = 0;

        public MVInputStream(HttpURLConnection con) {
            try {
                if (con != null) {
                    this.in = con.getInputStream();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public InputStream getInputStream() {
            return this.in;
        }

        @Override
        public int read() throws IOException {
            this.nr = this.in.read();
            if (this.nr != -1) {
                ++this.summe;
            }
            return this.nr;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.nr = this.in.read(b);
            if (this.nr != -1) {
                this.summe += (long)this.nr;
            }
            return this.nr;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.nr = this.in.read(b, off, len);
            if (this.nr != -1) {
                this.summe += (long)this.nr;
            }
            return this.nr;
        }
    }
}

