/*
 * Decompiled with CFR 0.152.
 */
package msearch;

import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.filmlisten.MSFilmlisteLesen;
import msearch.filmlisten.WriteFilmlistJson;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;

public class MSearch
implements Runnable {
    private ListeFilme listeFilme = new ListeFilme();
    private final MSFilmeSuchen msFilmeSuchen = new MSFilmeSuchen();
    private boolean serverLaufen = false;

    @Override
    public synchronized void run() {
        this.serverLaufen = true;
        MSConfig.setStop(false);
        if (MSConfig.dirFilme.isEmpty()) {
            MSLog.systemMeldung("Kein Pfad der Filmlisten angegeben");
            System.exit(-1);
        }
        MSLog.startMeldungen();
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        this.msFilmeSuchen.addAdListener(new MSListenerFilmeLaden(){

            @Override
            public void fertig(MSListenerFilmeLadenEvent event) {
                MSearch.this.serverLaufen = false;
            }
        });
        new MSFilmlisteLesen().readFilmListe(MSConfig.getPathFilmlist_json_akt(false), this.listeFilme, 0);
        if (MSConfig.nurSenderLaden == null) {
            this.msFilmeSuchen.filmeBeimSenderLaden(this.listeFilme);
        } else {
            this.msFilmeSuchen.updateSender(MSConfig.nurSenderLaden, this.listeFilme);
        }
        try {
            while (this.serverLaufen) {
                this.wait(5000L);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(496378742, "run()");
        }
        this.undTschuess();
    }

    public void stop() {
        if (this.serverLaufen) {
            MSConfig.setStop();
        }
    }

    public ListeFilme getListeFilme() {
        return this.listeFilme;
    }

    private void importUrl(ListeFilme tmpListe, String importUrl) {
        MSLog.systemMeldung("Filmliste importieren von: " + importUrl);
        tmpListe.clear();
        new MSFilmlisteLesen().readFilmListe(importUrl, tmpListe, 0);
        MSLog.systemMeldung("--> von  Anz. Filme: " + this.listeFilme.size());
        this.listeFilme.updateListe(tmpListe, false, false);
        MSLog.systemMeldung("--> nach Anz. Filme: " + this.listeFilme.size());
        tmpListe.clear();
        System.gc();
        this.listeFilme.sort();
    }

    private void importOld(ListeFilme tmpListe, String importUrl) {
        MSLog.systemMeldung("Alte Filmliste importieren von: " + importUrl);
        tmpListe.clear();
        new MSFilmlisteLesen().readFilmListe(importUrl, tmpListe, 0);
        MSLog.systemMeldung("--> von  Anz. Filme: " + this.listeFilme.size());
        int anz = this.listeFilme.updateListeOld(tmpListe);
        MSLog.systemMeldung("    gefunden: " + anz);
        MSLog.systemMeldung("--> nach Anz. Filme: " + this.listeFilme.size());
        tmpListe.clear();
        System.gc();
        this.listeFilme.sort();
    }

    private void undTschuess() {
        ListeFilme diff;
        boolean stop = MSConfig.getStop();
        MSConfig.setStop(false);
        this.listeFilme = this.msFilmeSuchen.listeFilmeNeu;
        ListeFilme tmpListe = new ListeFilme();
        MSLog.systemMeldung("");
        if (!MSConfig.importUrl_1__anhaengen.isEmpty()) {
            MSLog.systemMeldung("");
            MSLog.systemMeldung("============================================================================");
            MSLog.systemMeldung("Filmliste Import 1");
            this.importUrl(tmpListe, MSConfig.importUrl_1__anhaengen);
            MSLog.systemMeldung("");
        }
        if (!MSConfig.importUrl_2__anhaengen.isEmpty()) {
            MSLog.systemMeldung("");
            MSLog.systemMeldung("============================================================================");
            MSLog.systemMeldung("Filmliste Import 2");
            this.importUrl(tmpListe, MSConfig.importUrl_2__anhaengen);
            MSLog.systemMeldung("");
        }
        if (!MSConfig.importOld.isEmpty() && MSConfig.loadLongMax()) {
            MSLog.systemMeldung("");
            MSLog.systemMeldung("============================================================================");
            MSLog.systemMeldung("Filmliste OLD importieren");
            this.importOld(tmpListe, MSConfig.importOld);
            MSLog.systemMeldung("");
        }
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("============================================================================");
        MSLog.systemMeldung("============================================================================");
        MSLog.systemMeldung("Filmeliste fertig: " + this.listeFilme.size() + " Filme");
        MSLog.systemMeldung("============================================================================");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("   --> und schreiben:");
        new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_akt(false), this.listeFilme);
        new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_akt(true), this.listeFilme);
        new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_akt_xz(), this.listeFilme);
        MSLog.systemMeldung("");
        if (MSConfig.orgFilmlisteErstellen) {
            MSLog.systemMeldung("");
            MSLog.systemMeldung("============================================================================");
            MSLog.systemMeldung("Org-Lilste schreiben: " + MSConfig.getPathFilmlist_json_org());
            new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_org(), this.listeFilme);
            new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_org_xz(), this.listeFilme);
        }
        String org = MSConfig.orgFilmliste.isEmpty() ? MSConfig.getPathFilmlist_json_org() : MSConfig.orgFilmliste;
        MSLog.systemMeldung("");
        MSLog.systemMeldung("============================================================================");
        MSLog.systemMeldung("Diff erzeugen, von: " + org + " nach: " + MSConfig.getPathFilmlist_json_diff());
        tmpListe.clear();
        new MSFilmlisteLesen().readFilmListe(org, tmpListe, 0);
        if (tmpListe.isEmpty()) {
            MSLog.systemMeldung("   --> Lesefehler der Orgliste: Diff bleibt leer!");
            diff = new ListeFilme();
        } else if (tmpListe.isOlderThan(86400)) {
            MSLog.systemMeldung("   --> Orgliste zu alt: Diff bleibt leer!");
            diff = new ListeFilme();
        } else {
            diff = this.listeFilme.neueFilme(tmpListe);
        }
        MSLog.systemMeldung("   --> und schreiben:");
        new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_diff(), diff);
        new WriteFilmlistJson().filmlisteSchreibenJson(MSConfig.getPathFilmlist_json_diff_xz(), diff);
        MSLog.systemMeldung("   --> Anz. Filme Diff: " + diff.size());
        MSLog.endeMeldung();
    }
}

