/*  wmbday
 *  Copyright (C) 2003-2005 astratis <steffen@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef RING_H
#define RING_H


struct ring {
  char name[50];
  int day;
  int month;
  int year;
  struct ring* next;
};


/* adds a birthday to the list */
void ring_add(char* name, int day, int month, int year);

/* makes "current" point to the person, whose birthday is next to date specified by "day"/"month"*/
void ring_goto_date(int day, int month);

/* puts next "count" birthdays into "target" */
void ring_get_next(struct ring* target[], int number);

/* checks for birthday on date specified by "day"/"month" */
int ring_check_bday(int day, int month);

/* cleans up whole list */
void ring_clear(void);

#endif /* RING_H */
