# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvsroot/wmbday/build/wmbday-0.3.1.ebuild,v 1.1 2006/07/22 17:11:18 steffen Exp $

DESCRIPTION="wmbday is a Window Maker dock app that will remind you of birthdays"
HOMEPAGE="http://buzzinhornetz.ath.cx/wmbday/"
SRC_URI="http://buzzinhornetz.ath.cx/wmbday/files/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86"
IUSE="X"

DEPEND="virtual/x11"
# RDEPEND=""

inherit eutils

src_unpack()
{
	unpack ${A}
	cd ${S}
	econf || die "econf failed"
}

src_compile()
{   
	emake || die "Compilation failed"
}

src_install()
{
	dobin wmbday
	dodoc ChangeLog INSTALL data.sample.simple data.sample.vcard
	doman wmbday.1
}

pkg_postinst()
{
	einfo "Before you can use wmbday you must create"
	einfo "the directory ~/.wmbday/ and edit the file"
	einfo "data and fill it with your friends'"
	einfo "birthdays. You can also use a vcard-address-book"
	einfo "by creating a symbolic link to it."
	einfo "There are a sample files in /usr/share/doc/${P}"
}
