/*
 *   cmap.h
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef CMAP_H
#define CMAP_H

#include "defs.h"

typedef struct fb_cmap ColorMap;

ColorMap *ColorMap_alloc( __u32 length );
void ColorMap_free( ColorMap *cmap );
int ColorMap_copyDefault16( ColorMap *cmap );

#ifdef DEBUG
void ColorMap_dump( ColorMap *cmap, FILE *stream );
#endif

static inline __u16 ColorMap_getRed(   const ColorMap *cmap, __u32 n ) { return cmap->red[n] >> 8; }
static inline __u16 ColorMap_getGreen( const ColorMap *cmap, __u32 n ) { return cmap->green[n] >> 8; }
static inline __u16 ColorMap_getBlue(  const ColorMap *cmap, __u32 n ) { return cmap->blue[n] >> 8; }
static inline __u16 ColorMap_getAlpha( const ColorMap *cmap, __u32 n ) { return cmap->transp[n] >> 8; }

#endif /*CMAP_H*/
