/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AttrImpl
extends ParentNode
implements Attr {
    static final long serialVersionUID = 7277707688218972102L;
    protected String name;

    protected AttrImpl() {
    }

    protected AttrImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.name = string;
        this.specified(true);
    }

    public Node cloneNode(boolean bl) {
        AttrImpl attrImpl = (AttrImpl)super.cloneNode(bl);
        attrImpl.specified(true);
        return attrImpl;
    }

    public Element getElement() {
        return (Element)((Object)(this.owned() ? this.ownerNode : null));
    }

    public String getName() {
        if (this.syncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public String getNodeName() {
        if (this.syncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return (Element)((Object)(this.owned() ? this.ownerNode : null));
    }

    public boolean getSpecified() {
        if (this.syncData()) {
            this.synchronizeData();
        }
        return this.specified();
    }

    public String getValue() {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        if (this.firstChild == null) {
            return "";
        }
        ChildNode childNode = this.firstChild.nextSibling;
        if (childNode == null) {
            return this.firstChild.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer(this.firstChild.getNodeValue());
        while (childNode != null) {
            stringBuffer.append(childNode.getNodeValue());
            childNode = childNode.nextSibling;
        }
        return stringBuffer.toString();
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node2 != null && node.getNodeType() == 3 && node2.getNodeType() == 3) {
                ((Text)node).appendData(node2.getNodeValue());
                this.removeChild(node2);
                node2 = node;
            }
            node = node2;
        }
    }

    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    public void setSpecified(boolean bl) {
        if (this.syncData()) {
            this.synchronizeData();
        }
        this.specified(bl);
    }

    public void setValue(String string) {
        if (this.readOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        LCount lCount = null;
        String string2 = "";
        lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && this.ownerNode != null) {
            string2 = this.getValue();
        }
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        while (this.firstChild != null) {
            this.internalRemoveChild(this.firstChild, 1);
        }
        this.specified(true);
        if (string != null) {
            this.internalInsertBefore(this.ownerDocument.createTextNode(string), null, 1);
        }
        this.changed();
        this.dispatchAggregateEvents(this, string2);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + "\"" + this.getValue() + "\"";
    }
}

