/* lua/except.i: Custom Lua exception handling.
 * Warning: This file is generated by /data/home/olly/tmp/xapian-svn-snapshot/tags/1.2.8/xapian/xapian-bindings/lua/generate-lua-exceptions
 * - do not modify directly!
 *
 * Copyright 2011 Xiaona Han
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
namespace Xapian {

%exceptionclass Error;
%exceptionclass LogicError;
%exceptionclass RuntimeError;
%exceptionclass AssertionError;
%exceptionclass InvalidArgumentError;
%exceptionclass InvalidOperationError;
%exceptionclass UnimplementedError;
%exceptionclass DatabaseError;
%exceptionclass DatabaseCorruptError;
%exceptionclass DatabaseCreateError;
%exceptionclass DatabaseLockError;
%exceptionclass DatabaseModifiedError;
%exceptionclass DatabaseOpeningError;
%exceptionclass DatabaseVersionError;
%exceptionclass DocNotFoundError;
%exceptionclass FeatureUnavailableError;
%exceptionclass InternalError;
%exceptionclass NetworkError;
%exceptionclass NetworkTimeoutError;
%exceptionclass QueryParserError;
%exceptionclass SerialisationError;
%exceptionclass RangeError;
}
%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception(lua_State* L) {
    try {
	throw;
    } catch (const Xapian::RangeError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::SerialisationError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::QueryParserError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::NetworkTimeoutError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::NetworkError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::InternalError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::FeatureUnavailableError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DocNotFoundError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseVersionError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseOpeningError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseModifiedError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseLockError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseCreateError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseCorruptError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::DatabaseError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::UnimplementedError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::InvalidOperationError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::InvalidArgumentError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::AssertionError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::RuntimeError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const Xapian::LogicError &e) {
	std::string msg = e.get_type();
	msg +=": ";
	msg +=e.get_msg();
	luaL_error(L, "%s", msg.c_str());
    } catch (const std::exception& e) {
    } catch (...) {
    }
}
};
%}

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception(L);
	SWIG_fail;
    }
}
