/*
  Copyright (C) 2009  Arne Caspari <arne@unicap-imaging.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __UTILS_H__
#define __UTILS_H__

#include <Python.h>
#include <structmember.h>
#include <unicap.h>

#ifndef __HIDDEN__
#define __HIDDEN__ __attribute__((visibility("hidden")))
#endif//__HIDDEN

__HIDDEN__ int parse_video_format( unicap_format_t *format, PyObject *obj );
__HIDDEN__ PyObject *build_video_format( const unicap_format_t *format );
__HIDDEN__ PyObject *build_property( const unicap_property_t *property );
__HIDDEN__ int parse_property( unicap_property_t *property, PyObject *obj );
__HIDDEN__ int conv_device_identifier( PyObject *object, char **target );



#endif//__UTILS_H__
