/*
 *
 * Edscott Wilson Garcia 2001-5
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
 * 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rfm.h"
#include "rfm_modules.h"


static const gchar *
uri_remove_file_prefix (gchar * path) {
    static gchar *url_he = NULL;
    if(strncmp (path, "file:/", strlen ("file:/")) == 0 && !strstr (path, "file://")) {
        /* assume local */
        const gchar *f = "file:";
        memmove (path, path + strlen (f), strlen (path + strlen ("file:")) + 1);
        NOOP ("case file:/\n");
        return NULL;
    }
    if(strncmp (path, "file:///", strlen ("file:///")) == 0) {
        /* assume local again */
        const gchar *f = "file://";
        memmove (path, path + strlen (f), strlen (path + strlen (f)) + 1);
        NOOP ("case file:///\n");
        return NULL;
    }

    if(strncmp (path, "file://", strlen ("file://")) == 0) {
        /* local? */
        const gchar *f = "file:/";
        if(rfm_g_file_test (path + strlen (f), G_FILE_TEST_EXISTS)) {
            /* local it is */
            NOOP ("case local file://\n");
            memmove (path, path + strlen (f), strlen (path + strlen (f)) + 1);
            return NULL;
        }
        NOOP ("case remote file://\n");
        memmove (path, path + strlen ("file://"), strlen (path + strlen ("file://")) + 1);
        g_free (url_he);
        url_he = g_strdup (path);
        if(strchr (url_he, '/'))
            *strchr (url_he, '/') = 0;
        memmove (path, path + strlen (url_he), strlen (path + strlen (url_he)) + 1);
        return url_he;
    }
    NOOP ("not file:\n");
    return (NULL);
}

void
rfm_uri_remove_file_prefix_from_list (GList * list, const gchar * he, const gchar * me) {
    while(list) {
        gchar *url = (gchar *) list->data;
        if(strncmp (url, "file:", strlen ("file:")) == 0) {
            const gchar *url_he;
            NOOP ("url=%s\n", url);
            url_he = uri_remove_file_prefix (url);
            NOOP ("removed url=%s\n", url);

            if(strcmp (me, he)) {
                /* remote request */
                gchar *fixed_url;
                if(url_he) {
                    fixed_url = g_strdup_printf ("%s:%s", url_he, url);
                } else {
                    fixed_url = g_strdup_printf ("%s:%s", he, url);
                }
                g_free (list->data);
                list->data = fixed_url;
            }
            NOOP ("fixed url=%s\n", url);
        }
        list = list->next;
    }
    return;
}

int
rfm_uri_parse_list (const gchar * text, GList ** list) {
    gchar *q,
     *p,
     *linesep;

    NOOP ("uri text: %s\n", text);

    q = p = g_strdup (text);

    if(strstr (p, "\r\n"))
        linesep = "\r\n";
    else if(strstr (p, "\n"))
        linesep = "\n";
    else if(strstr (p, "\r"))
        linesep = "\r";
    else if(strlen (p)) {
        *list = g_list_append (*list, g_strdup (p));
        NOOP ("add list: %s\n", p);
        return TRUE;
    } else
        return FALSE;

    for(p = strtok (p, linesep); p; p = strtok (NULL, linesep)) {
        gchar *t = g_strdup (p);
        NOOP ("add list: %s\n", t);
        *list = g_list_append (*list, t);
    }
    g_free (q);
    return TRUE;
}

GList *
rfm_uri_free_list (GList * list) {
    GList *t;
    for(t = list; t; t = t->next)
        g_free (t->data);
    g_list_free (list);
    return NULL;
}
