#ifndef RFM_PRIMARY_LAYOUT_H
# define RFM_PRIMARY_LAYOUT_H


#define ICON_SIZE(X) rfm_layout_get_icon_size(X)
#define ICON_SIZE_ID(X) rfm_layout_get_icon_size_id(X)
#define CELLHEIGHT(X) rfm_layout_get_cellheight(X)
#define CELLWIDTH(X) rfm_layout_get_cellwidth(X)
#define GRID_ROWS(X) rfm_layout_get_grid_rows(X)
#define GRID_COLUMNS(X) rfm_layout_get_grid_columns(X)
#define MARGIN_TOP(X) rfm_layout_get_margin_top(X)
#define MARGIN_BOTTOM(X) rfm_layout_get_margin_bottom(X)
#define MARGIN_RIGHT(X) rfm_layout_get_margin_right(X)
#define MARGIN_LEFT(X) rfm_layout_get_margin_left(X)
#define MAX_ELEMENTS(X) rfm_layout_get_max_elements(X)
#define ROOT_HEIGHT(X) rfm_layout_get_root_width(X)
#define ROOT_WIDTH(X)  rfm_layout_get_root_height(X)
#define ROOT_DEPTH(X)  rfm_layout_get_root_depth(X)
#define TEXT_HEIGHT(X)  rfm_layout_get_text_height(X)
#define NAME_WIDTH(X)  rfm_layout_get_name_width(X)

GtkAllocation *rfm_get_allocation(void);
void rfm_set_allocation(GtkAllocation *allocation);

const gchar **rfm_get_icon_sizes(void);
const gchar **rfm_get_font_sizes(void);
gint rfm_layout_get_text_height(view_t *view_p);
gint rfm_layout_get_name_width(view_t *view_p);
gint rfm_layout_set_root_width(view_t *view_p, gint value);
gint rfm_layout_set_root_height(view_t *view_p, gint value);
gint rfm_layout_get_root_width(view_t *view_p);
gint rfm_layout_get_root_height(view_t *view_p);
gint rfm_layout_get_root_depth(view_t *view_p);
gint rfm_layout_get_max_elements(view_t *view_p);
gint rfm_layout_set_margin_top(view_t *view_p, gint value);
gint rfm_layout_set_margin_bottom(view_t *view_p, gint value);
gint rfm_layout_set_margin_right(view_t *view_p, gint value);
gint rfm_layout_set_margin_left(view_t *view_p, gint value);
gint rfm_layout_get_margin_top(view_t *view_p);
gint rfm_layout_get_margin_bottom(view_t *view_p);
gint rfm_layout_get_margin_right(view_t *view_p);
gint rfm_layout_get_margin_left(view_t *view_p);
gboolean rfm_layout_set_window_size(view_t *view_p, gint width, gint height);
gboolean rfm_layout_is_setup(view_t *view_p);
gint rfm_layout_get_grid_rows(view_t *view_p);
gint rfm_layout_get_grid_columns(view_t *view_p);
gint rfm_layout_get_cellheight(view_t *view_p);
gint rfm_layout_get_cellwidth(view_t *view_p);
gint rfm_layout_get_icon_size(view_t *view_p);
gint rfm_layout_get_icon_size_id(view_t *view_p);
gboolean rfm_layout_is_details_size(view_t *view_p);
void rfm_layout_set_root_parameters(view_t *view_p);
void rfm_layout_get_root_parameters(view_t *view_p, gint *width, gint *height, gint *depth);

void 
rfm_get_drawable_geometry(Drawable drawable, 
	gint *x, gint *y, gint *w, gint *h, gint *d);

gint
rfm_get_default_size(void);

view_preferences_t *
rfm_get_view_preferences (gint type, record_entry_t *target_en);

void
rfm_save_view_preferences (view_t * view_p, record_entry_t *target_en);

void
rfm_set_view_preferences (view_t * view_p, view_preferences_t *view_preferences_p);

void rfm_layout_set_vpane_allocation(view_t *view_p);
void rfm_layout_get_vpane_allocation(view_t *view_p, GdkRectangle *rect);

void rfm_layout_set_icon_size(view_t *view_p, gint size);
void rfm_layout_set_icon_size_full(view_t *view_p, gint size);

void 
rfm_layout_pango_layout_setup(view_t *view_p);

// Do this after iconsize changes:
void 
rfm_layout_reset_columns(view_t *view_p);

void 
rfm_layout_configure(view_t *view_p, gint pathc);
////////////////////
void
rfm_layout_cleanup(population_t *population_p);

gboolean 
rfm_get_population_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

gboolean 
rfm_get_population_icon_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

gboolean 
rfm_get_population_label_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

gboolean 
rfm_get_population_label_rect_full(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

void
rfm_do_layout (view_t * view_p, population_t * population_p);
#endif
