/*	Revision History	*/
/*	Bryan Christ - Inception:  Wed Nov  9 10:58:34 2005	*/

#ifndef _H_LIB_PSEUDO_
#define _H_LIB_PSEUDO_

#include <inttypes.h>

#include <glib.h>

/*	Shared Message Queue status codes	*/
enum
{
	SHMQ_OK=0,
	SHMQ_QUEUE_INVALID,
	SHMQ_QUEUE_FULL,
	SHMQ_MSG_INVALID
};

/*	Pseudo Threads scheduler types		*/
enum
{
	PS_SCHED_LEAPFROG=1
};


/*	Return codes for Pseuod Threads		*/
enum
{
	PSTHREAD_ERR=-1,
	PSTHREAD_CONTINUE,
	PSTHREAD_GROW,
	PSTHREAD_TERMINATE
};

typedef struct _ps_task_s	ps_task_t;
typedef struct	_ps_runq_s	ps_runq_t;

typedef gint (*PSTHREAD)(ps_task_t *task,gpointer anything);

ps_runq_t*	psthread_init(gint scheduler);
ps_task_t*	psthread_add(ps_runq_t *run_q,PSTHREAD callback,gpointer anything);
gint			psthread_del(ps_runq_t *run_q,ps_task_t *task);
void			psthread_run(ps_runq_t *run_q,guint tasks);
guint			psthread_count(ps_runq_t *run_q);

/*	shared message queue (shmq) functions	*/
gint			shmq_msg_put(const gchar *queue_name,gpointer anything);
gpointer		shmq_msg_get(const gchar *queue_name);
guint			shmq_size(const gchar *queue_name);
#endif
