/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _POVPARSER_H_
#define _POVPARSER_H_

#include "xpe_components/parser/fileparser.h"
#include "xpe_components/parser/povfileinfo.h"
#include "lib/commons.h"

/**
 * Parser sp�cifique aux fichiers pov
 */
class PovParser : public FileParser
{
    protected:
        /**
         * pr�pare le parser pour scanner un fichier dont on passe les infos actuelles en param�tre
         * @param info informations actuellement connues sur le fichier (surtout le nom, l'id et le type)
         * @return true si le parser peut g�rer le fichier demand� et que le parser n'est pas actuellement en fonction,
         *          false dans le cas contraire
         */
        virtual bool prepareParserImpl(const FileInfo * info);
        /**
         * effectue le parsing du fichier pr�par�. Cette m�thode est apell�e lors du passage dans startParsing
         * uniquement si le parser est en �tat Prepared.
         * @return true si le parsing s'est d�roul� correctement
         */
        virtual bool parse();
        /**
         * r�cup�re les infos collect�es lors du dernier parsing (uniquement en �tat Finished).
         * Cette m�thode est apell�e par getParsedInfo uniquement si le parser est en �tat Finished.
         * @return NULL si il n'y a pas eu de parsing depuis la cr�ation de l'instance ou la derni�re pr�paration
         */
        virtual FileInfo * getParsedInfoImpl();

    private:
        PovFileInfo infos;
};

#endif // _POVPARSER_H_
