/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _PARSING_THREAD_H_
#define _PARSING_THREAD_H_

#include "components/framework/tapplication.h"
#include "lib/lib_string.h"
#include "lib/commons.h"

#include <set>
#include <map>
#include <wx/thread.h>

class FileInfo;

class FileParserRes;
class FileParser;

class ParsingThread : public wxThread
{

    public:
        ParsingThread(FileParserRes * _filesRes) : wxThread(wxTHREAD_JOINABLE), filesRes(_filesRes) {}
        virtual ~ParsingThread(){}

        /** essaye d'arreter le thread */
        void requestStop();

        /** scanne un fichier (sans verifier si cela est n�cessaire) */
        static bool scanFile(FileInfo * fileInfo, FileParserRes * filesRes);
        /** v�rifie si un fichier a besoin d'etre scann� */
        static bool requireScan(FileInfo * fileInfo);

    protected:
        virtual ExitCode Entry();

    private:
        FileParserRes * filesRes;
};


#endif // _PARSING_THREAD_H_
