/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TOOLS_PANEL_ELEMENT_H_
#define _TOOLS_PANEL_ELEMENT_H_

#include "lib/commons.h"
#include "components/stdgui/toolbar_panelelt.h"
#include "components/framework/elementinfo.h"


#define PELT_TYPE_TOOLS "PELT_TYPE_TOOLS"

/**
 * @short Un �l�ment de panneau d'application affichant des icones d'outils
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolsPanelElement : public ToolbarPanelElement
{
    TRANSLATABLE;
    public:
        ToolsPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolsPanelElement();

        /** renvoie une constante identifiant le type de cet �l�ment de mani�re a pouvoir le reconstruire lors du chargement des pr�f�rences */
        virtual const char * getElementType() const { return PELT_TYPE_TOOLS; }

        /** indique si le composant doit etre sauvegard� */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TOOLS,wxSTr("Tools"), NULL, 0, 1); }

        /**
         * se d�clanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton press�
         * @param bStateDown indique si le bouton est enfonc� ou relach�
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown);

};

#endif // _TOOLS_PANEL_ELEMENT_H_
