/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STD_TOOLBARS_PELT_H_
#define _STD_TOOLBARS_PELT_H_

#include "lib/commons.h"
#include "components/stdgui/toolbar_panelelt.h"
#include "components/framework/elementinfo.h"


#define PELT_TYPE_TOOLBAR_FILE "PELT_TYPE_TOOLBAR_FILE"

/**
 * @short Une barre d'outils contenant les boutons pour les actions concernant les fichiers
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolbarFilePanelElement : public ToolbarPanelElement
{
    TRANSLATABLE;
    public:
        ToolbarFilePanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolbarFilePanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TOOLBAR_FILE; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TOOLBAR_FILE,wxSTr("File toolbar"), NULL, 0, 1); }

        /**
         * se declanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton presse
         * @param bStateDown indique si le bouton est enfonce ou relache
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown);

};

#define PELT_TYPE_TOOLBAR_EDIT "PELT_TYPE_TOOLBAR_EDIT"

/**
 * @short Une barre d'outils contenant les boutons pour les actions concernant l'edition de base
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolbarEditPanelElement : public ToolbarPanelElement
{
    TRANSLATABLE;
    public:
        ToolbarEditPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolbarEditPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TOOLBAR_EDIT; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TOOLBAR_EDIT,wxSTr("Edit toolbar"), NULL, 0, 1); }

        /**
         * se declanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton presse
         * @param bStateDown indique si le bouton est enfonce ou relache
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown);

};

#define PELT_TYPE_TOOLBAR_EDIT2 "PELT_TYPE_TOOLBAR_EDIT2"

/**
 * @short Une barre d'outils contenant les boutons pour les actions concernant l'edition avancee
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolbarEdit2PanelElement : public ToolbarPanelElement
{
    TRANSLATABLE;
    public:
        ToolbarEdit2PanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolbarEdit2PanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TOOLBAR_EDIT2; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TOOLBAR_EDIT2,wxSTr("Advanced edition toolbar"), NULL, 0, 1); }

        /**
         * se declanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton presse
         * @param bStateDown indique si le bouton est enfonce ou relache
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown);

};

#define PELT_TYPE_TOOLBAR_SEARCH "PELT_TYPE_TOOLBAR_SEARCH"

/**
 * @short Une barre d'outils contenant les boutons pour les actions concernant la recherche
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolbarSearchPanelElement : public ToolbarPanelElement
{
    TRANSLATABLE;
    public:
        ToolbarSearchPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolbarSearchPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TOOLBAR_SEARCH; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TOOLBAR_SEARCH,wxSTr("Search toolbar"), NULL, 0, 1); }

        /**
         * se declanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton presse
         * @param bStateDown indique si le bouton est enfonce ou relache
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown);

};

#endif // _STD_TOOLBARS_PELT_H_
