/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "std_toolbars.h"

#include "components/framework/tapplication.h"
#include "components/framework/tmainwindow.h"
#include "xpe_components/mainwindow.h"

#include "lib/lib_string.h"
#include "lib/lib_logging.h"

#include "bmp_id.h"

ToolbarFilePanelElement::ToolbarFilePanelElement(TApplicationPanel * _owner, int iID)
    : ToolbarPanelElement(_owner, iID)
{
    this->addButton( XPEMainWindow::File_PovNew, GET_BMP(BMP_FILE_POVRAY_ID), wxT(""), wxTr("Create new povray file"), false);
    this->addButton( XPEMainWindow::File_Open, GET_BMP(BMP_FILE_OPEN_22_ID), wxT(""), wxTr("Open file ..."), false);
    this->addButton( XPEMainWindow::File_Save, GET_BMP(BMP_FILE_SAVE_22_ID), wxT(""), wxTr("Save file"), false);
}

ToolbarFilePanelElement::~ToolbarFilePanelElement()
{
}

// void ToolsPanelElement::buttonActivated(TGenButton * btn)
void ToolbarFilePanelElement::buttonClicked(int iButtonID, bool bStateDown)
{
    XPEMainWindow * mainWindow = dynamic_cast<XPEMainWindow *>(CurrentApplication()->getMainWindow());
    if(!mainWindow)
        return;

    wxCommandEvent evt(0,iButtonID);

    if(iButtonID == XPEMainWindow::File_PovNew)
    {
        mainWindow->OnFileNew(evt);
    }
    else if(iButtonID == XPEMainWindow::File_Open)
    {
        mainWindow->OnFileOpen(evt);
    }
    else if(iButtonID == XPEMainWindow::File_Save)
    {
        mainWindow->OnFileSave(evt);
    }
}






ToolbarEditPanelElement::ToolbarEditPanelElement(TApplicationPanel * _owner, int iID)
    : ToolbarPanelElement(_owner, iID)
{
    this->addButton( XPEMainWindow::Edit_Undo, GET_BMP(BMP_UNDO_22_ID), wxT(""), wxTr("Undo last action"), false);
    this->addButton( XPEMainWindow::Edit_Redo, GET_BMP(BMP_REDO_22_ID), wxT(""), wxTr("Redo last action"), false);
    this->addSeparator();
    this->addButton( XPEMainWindow::Edit_Cut, GET_BMP(BMP_EDIT_CUT_22_ID), wxT(""), wxTr("Cut current selection"), false);
    this->addButton( XPEMainWindow::Edit_Copy, GET_BMP(BMP_EDIT_COPY_22_ID), wxT(""), wxTr("Copy current selection"), false);
    this->addButton( XPEMainWindow::Edit_Paste, GET_BMP(BMP_EDIT_PASTE_22_ID), wxT(""), wxTr("Paste clipboard content"), false);
}

ToolbarEditPanelElement::~ToolbarEditPanelElement()
{
}

// void ToolsPanelElement::buttonActivated(TGenButton * btn)
void ToolbarEditPanelElement::buttonClicked(int iButtonID, bool bStateDown)
{
    XPEMainWindow * mainWindow = dynamic_cast<XPEMainWindow *>(CurrentApplication()->getMainWindow());
    if(!mainWindow)
        return;

    EditorPanelElement * editor = dynamic_cast<EditorPanelElement *>( getMainWindowCenterPanel()->getFirstVisibleElement());
    if(!editor)
        return;

    editor->getEditor()->SetFocus();

    wxCommandEvent evt(0,iButtonID);

    if(iButtonID == XPEMainWindow::Edit_Undo || iButtonID == XPEMainWindow::Edit_Redo)
    {
        mainWindow->OnEditUndoRedo(evt);
    }
    else if(iButtonID == XPEMainWindow::Edit_Cut || iButtonID == XPEMainWindow::Edit_Copy || iButtonID == XPEMainWindow::Edit_Paste)
    {
        mainWindow->OnEditCutCopyPaste(evt);
    }
}






ToolbarEdit2PanelElement::ToolbarEdit2PanelElement(TApplicationPanel * _owner, int iID)
    : ToolbarPanelElement(_owner, iID)
{
    this->addButton( XPEMainWindow::Edit_JoinLines, GET_BMP(BMP_JOIN_LINES_22_ID), wxT(""), wxTr("Join current and next lines"), false);
    this->addButton( XPEMainWindow::Edit_DeleteLine, GET_BMP(BMP_REMOVE_LINE_22_ID), wxT(""), wxTr("Delete current line"), false);
    this->addSeparator();
    this->addButton( XPEMainWindow::Edit_CommentIn, GET_BMP(BMP_COMMENT_IN_22_ID), wxT(""), wxTr("Comment code"), false);
    this->addButton( XPEMainWindow::Edit_CommentOut, GET_BMP(BMP_COMMENT_OUT_22_ID), wxT(""), wxTr("Uncomment code"), false);
}

ToolbarEdit2PanelElement::~ToolbarEdit2PanelElement()
{
}

// void ToolsPanelElement::buttonActivated(TGenButton * btn)
void ToolbarEdit2PanelElement::buttonClicked(int iButtonID, bool bStateDown)
{
    XPEMainWindow * mainWindow = dynamic_cast<XPEMainWindow *>(CurrentApplication()->getMainWindow());
    if(!mainWindow)
        return;

    EditorPanelElement * editor = dynamic_cast<EditorPanelElement *>( getMainWindowCenterPanel()->getFirstVisibleElement());
    if(!editor)
        return;

    editor->getEditor()->SetFocus();

    wxCommandEvent evt(0,iButtonID);

    if(iButtonID == XPEMainWindow::Edit_JoinLines)
    {
        mainWindow->OnEditJoinLines(evt);
    }
    if(iButtonID == XPEMainWindow::Edit_DeleteLine)
    {
        mainWindow->OnEditDeleteLine(evt);
    }
    else if(iButtonID == XPEMainWindow::Edit_CommentIn || iButtonID == XPEMainWindow::Edit_CommentOut)
    {
        mainWindow->OnEditComment(evt);
    }
}






ToolbarSearchPanelElement::ToolbarSearchPanelElement(TApplicationPanel * _owner, int iID)
    : ToolbarPanelElement(_owner, iID)
{
    this->addButton( XPEMainWindow::Edit_Find, GET_BMP(BMP_FILE_FIND_22_ID), wxT(""), wxTr("Search text"), false);
    this->addButton( XPEMainWindow::Edit_FindNext, GET_BMP(BMP_FILE_FIND_NEXT_22_ID), wxT(""), wxTr("Go to next occurence"), false);
    this->addButton( XPEMainWindow::Edit_Replace, GET_BMP(BMP_FILE_REPLACE_22_ID), wxT(""), wxTr("Replace"), false);
}

ToolbarSearchPanelElement::~ToolbarSearchPanelElement()
{
}

// void ToolsPanelElement::buttonActivated(TGenButton * btn)
void ToolbarSearchPanelElement::buttonClicked(int iButtonID, bool bStateDown)
{
    XPEMainWindow * mainWindow = dynamic_cast<XPEMainWindow *>(CurrentApplication()->getMainWindow());
    if(!mainWindow)
        return;

    EditorPanelElement * editor = dynamic_cast<EditorPanelElement *>( getMainWindowCenterPanel()->getFirstVisibleElement());
    if(!editor)
        return;

    editor->getEditor()->SetFocus();

    wxCommandEvent evt(0,iButtonID);

    if(iButtonID == XPEMainWindow::Edit_Find)
    {
        mainWindow->OnEditFind(evt);
    }
    if(iButtonID == XPEMainWindow::Edit_FindNext)
    {
        mainWindow->OnEditFindNext(evt);
    }
    else if(iButtonID == XPEMainWindow::Edit_Replace)
    {
        mainWindow->OnEditReplace(evt);
    }
}






