/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _NOTES_PANEL_ELEMENT_H_
#define _NOTES_PANEL_ELEMENT_H_

#include <wx/menu.h>
#include <wx/event.h>
#include "lib/commons.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/elementinfo.h"

#define PELT_TYPE_NOTES "PELT_TYPE_NOTES"

class wxTextCtrl;

/**
 * @short Un �l�ment de panneau d'application affichant un bloc notes
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class NotesPanelElement : public TPanelElement
{
    TRANSLATABLE;
    public:
        NotesPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~NotesPanelElement();

        /** renvoie une constante identifiant le type de cet �l�ment de mani�re a pouvoir le reconstruire lors du chargement des pr�f�rences */
        virtual const char * getElementType() const { return PELT_TYPE_NOTES; }

        /** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();
        /** indique si le composant doit etre sauvegard� */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_NOTES,wxSTr("Notes"), getDefaultIcon(), 0, 99); }

        /** renvoie l'icone associ�e au composant */
        static const TBitmap * getDefaultIcon();

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

    private:
        wxTextCtrl * notes;
};

#endif // _NOTES_PANEL_ELEMENT_H_
