/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "notes_panelelt.h"

#include <wx/textctrl.h>

#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"

#include "lib/lib_string.h"

#include "bmp_id.h"

NotesPanelElement::NotesPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT(""), wxT("")),
    notes(NULL)
{
    this->setTooltip(wxTr("Take your notes here"));
    this->setExtensivity(1);
    this->setBitmap(getDefaultIcon());
}

NotesPanelElement::~NotesPanelElement()
{
}

const TBitmap * NotesPanelElement::getDefaultIcon()
{
    return GET_BMP(BMP_BLOC_NOTES_ID);
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * NotesPanelElement::buildContentPanel()
{
    TPanel * contentPanel = new TPanel(this->getOwner()->getContentPanel());
    wxBoxSizer * sizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(sizer);

    this->notes = new wxTextCtrl(contentPanel, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_TAB|wxTE_MULTILINE|wxTE_NOHIDESEL|wxTE_BESTWRAP);

    sizer->Add(this->notes,1,wxEXPAND);
    sizer->Show(this->notes,true);

    return contentPanel;
}


#define XML_PARAM_NODE_DATA "NotesData"

/** charge les parametres du composant a partir des informations contenues dans le noeud pass en paramtre */
bool NotesPanelElement::loadParameters(TiXmlElement * parametersNode)
{
    TPanelElement::loadParameters(parametersNode);

    TiXmlElement * elt = parametersNode->FirstChildElement(XML_PARAM_NODE_DATA);
    if(!elt)
        return false;

    this->notes->SetValue(ISO2WX(elt->GetText()));

    return true;
}

/** renvoie les parametres du composant sous la forme d'un noeud xml */
TiXmlElement * NotesPanelElement::getParameters()
{
    TiXmlElement * root = TPanelElement::getParameters();
    TiXmlElement * elt = new TiXmlElement(XML_PARAM_NODE_DATA);
    TiXmlText * txt = new TiXmlText((const char *)this->notes->GetValue().fn_str());
    txt->SetCDATA( true );
    elt->LinkEndChild( txt );

    root->LinkEndChild( elt );

    return root;
}

