/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _FILE_EXPLORER_PANEL_ELEMENT_H_
#define _FILE_EXPLORER_PANEL_ELEMENT_H_

#include <wx/event.h>
#include <wx/textctrl.h>
#include <wx/imaglist.h>

#include "lib/commons.h"
#include "lib/lib_string.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/elementinfo.h"

#define PELT_TYPE_FILE_EXPLORER "PELT_TYPE_FILE_EXPLORER"

class TListCtrl;

/**
 * @short Un element de panneau d'application affichant le contenu du syst�me de fichier
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class FileExplorerPanelElement : public TPanelElement, public wxEvtHandler
{
    TRANSLATABLE;
    public:
        FileExplorerPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~FileExplorerPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_FILE_EXPLORER; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_FILE_EXPLORER,wxSTr("Explorer"), getDefaultIcon(), 0, 99); }

        /** renvoie l'icone associ�e au composant */
        static const TBitmap * getDefaultIcon();

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();


        /**
         * mets a jour l'affichage avec le chemin pass� en param�tre
         * @param sPath chemin a afficher
         */
        void displayDirectory(wxString sPath);

        void onNewPathEntered(wxCommandEvent & event);
        void onListViewSize(wxSizeEvent & evt);
        void onListDblClick(wxCommandEvent & event);

    private:
        wxString sCurrentPath;
        wxTextCtrl * path;
        TListCtrl * files;
        TStringList datas;
        wxImageList icons;

        long iLastResizeTime;
        long iResizeCount;
};

#endif // _FILE_EXPLORER_PANEL_ELEMENT_H_
