/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "documents_panelelt.h"

#include "components/stdgui/tlistctrl.h"

#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"
#include "xpe_components/mainwindow.h"
#include "xpe_components/editor/editor_panelelement.h"

#include "lib/lib_string.h"

#include "bmp_id.h"

int wxCALLBACK _DocumentsCompareFunction(long iItem1Data, long iItem2Data, long iSortData);

DocumentsPanelElement::DocumentsPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT(""), wxT("")),
    docs(NULL)
{
    this->setTooltip(wxTr("Open documents"));
    this->setExtensivity(1);
    this->setBitmap(getDefaultIcon());

    getMainWindowCenterPanel()->addPanelListener( this );
}

DocumentsPanelElement::~DocumentsPanelElement()
{
    if(getMainWindowCenterPanel())
        getMainWindowCenterPanel()->removePanelListener( this );
}

const TBitmap * DocumentsPanelElement::getDefaultIcon()
{
    return GET_BMP(BMP_DOCUMENTS_ID);
}

/** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
TPanel * DocumentsPanelElement::buildContentPanel()
{
    TPanel * contentPanel = new TPanel(this->getOwner()->getContentPanel());
    wxBoxSizer * sizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(sizer);

    this->docs = new TListCtrl(contentPanel, -1, wxDefaultPosition, wxDefaultSize,
                                    wxLC_REPORT | wxLC_NO_HEADER | wxLC_SINGLE_SEL | wxSUNKEN_BORDER );

    sizer->Add(this->docs,1,wxEXPAND);
    sizer->Show(this->docs,true);

    // entetes des colonnes (cach�es)
    wxListItem itemCol;
    itemCol.SetText(wxT(" "));
    itemCol.SetImage(-1);
    this->docs->InsertColumn(0, itemCol);

    this->docs->Connect(wxEVT_SIZE,wxSizeEventHandler(DocumentsPanelElement::onListViewSize), NULL, this);
    this->docs->Connect(wxEVT_COMMAND_LIST_ITEM_ACTIVATED,wxCommandEventHandler(DocumentsPanelElement::onListDblClick), NULL, this);

    this->updateDocumentsList();

    return contentPanel;
}

/** indique qu'un element va etre supprime d'un paneau */
void DocumentsPanelElement::removingElement(TApplicationPanel * panel, TPanelElement * elt)
{
    this->updateDocumentsList();
}

/** indique qu'un element est ajoute � un panneau */
void DocumentsPanelElement::addingElement(TApplicationPanel * panel, TPanelElement * elt)
{
    this->updateDocumentsList();
}

/** indique que les donn�es d'un element ont chang� */
void DocumentsPanelElement::elementDataChanged(TApplicationPanel * panel, const TPanelElement * elt)
{
    this->updateDocumentsList();
}


/** mets a jour la liste des documents ouverts */
void DocumentsPanelElement::updateDocumentsList()
{
    if(!this->docs)
        return;

    this->docs->DeleteAllItems();

    for(int i = 0 ; i < getMainWindowCenterPanel()->getElementsCount() ; i++)
    {
        EditorPanelElement * elt = static_cast<EditorPanelElement *>(getMainWindowCenterPanel()->getElementAt(i));
        long iItemId = this->docs->InsertItem(0,elt->getName());
        this->docs->SetItemData(iItemId, elt->getID());
    }

    this->docs->SortItems(&_DocumentsCompareFunction,0);

}

void DocumentsPanelElement::onListViewSize(wxSizeEvent & evt)
{
    evt.Skip();
    if(this->docs && this->docs->GetClientSize().GetWidth()>0)
    {
        this->docs->SetColumnWidth( 0, this->docs->GetClientSize().GetWidth() - 2 );
    }
}

void DocumentsPanelElement::onListDblClick(wxCommandEvent & event)
{
    if(!this->docs)
        return;

    for(int iItemId = 0 ; iItemId < this->docs->GetItemCount() ; iItemId++)
    {
        if(this->docs->GetItemState(iItemId,wxLIST_STATE_SELECTED))
        {
            long iEltId = this->docs->GetItemData(iItemId);

            getMainWindowCenterPanel()->setElementVisible(iEltId,true);
            static_cast<EditorPanelElement *>(getMainWindowCenterPanel()->getElement(iEltId))->getEditor()->SetFocus();

            break;
        }
    }
}


int wxCALLBACK _DocumentsCompareFunction(long iItem1Data, long iItem2Data, long iSortData)
{
    TApplicationPanel * panel = getMainWindowCenterPanel();

    return panel->getElement( iItem1Data )->getName().CmpNoCase(panel->getElement( iItem2Data )->getName());
}
