/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _XPE_MAINWINDOW_H_
#define _XPE_MAINWINDOW_H_

#include <map>
#include <wx/string.h>
#include <wx/docview.h>
#include "lib/commons.h"
#include "components/codeeditor/tcodeeditor.h"
#include "components/framework/elementinfo.h"
#include "components/framework/tmainwindow.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/tpanelelement.h"
#include "xpe_components/editor/editor_panelelement.h"
#include "xpe_components/dlg/replace_dlg.h"
#include "xpe_components/dlg/search_dlg.h"

DECLARE_EVENT_TYPE(EVENT_CLOSE_TAB, -1);

class XPE;

/**
 * Fenetre principale de l'application XPE
 * @short Fenetre principale de l'application XPE
 */
class XPEMainWindow : public TMainWindow, protected TApplicationPanelListener, protected TCodeEditorListener, protected TCursorListener
{
    TRANSLATABLE;
    public:
        XPEMainWindow(XPE * application);
        virtual ~XPEMainWindow();

        enum FileTabType { Povfile, Inifile, ImageFile };

        /**
         * cree un nouveau panneau d'edition du type passe en parametre
         * @param type type d'editeur a creer
         * @return l'editeur cree
         */
        EditorPanelElement * createNewEditorTab(FileTabType type);

        /**
         * recherche un editeur dans la liste des fichiers ouverts
         */
        TPanelElement * getTabFromFile(const wxString & sFilename);

        /**
         * recherche un editeur dans la liste des fichiers ouverts
         */
        TPanelElement * getTabFromId(int iEditorId);

        /**
         * charge le fichier sFilename
         */
        bool loadFile(const wxString & sFilename);

        /**
         * ecris l'editeur actuellement visible
         */
        bool writeFile();

        /**
         * ecris l'editeur dans un fichier s�lectionnable
         */
        bool writeFileAs(FileViewerPanelElement * elt);

        /**
         * ecris l'editeur actuellement visible dans un fichier s�lectionnable
         */
        bool writeFileAs();

        /**
         * ecris l'editeur actuellement visible sous le nom de fichier sFilename
         */
        bool writeFile(const wxString & sFilename);

        /**
         * ecris l'editeur passe en parametre
         */
        bool writeFile(FileViewerPanelElement * elt);

        /**
         * ecris l'editeur passe en parametre sous le nom de fichier sFilename
         */
        bool writeFile(FileViewerPanelElement * elt, const wxString & sFilename);

        /** demande la fermeture d'un onglet, la fermeture n'est pas immdiate mais diffre */
        void requestTabClose(FileViewerPanelElement * eltToClose);

        /**
         * ferme l'onglet courrant apres avoir proc�d� a une �ventuelle sauvegarde
         */
        void closeTab();

        /**
         * ferme l'onglet apres avoir proc�d� a une �ventuelle sauvegarde
         */
        void closeTab(FileViewerPanelElement * elt);

        /** demande la fermeture de la fenetre */
        virtual bool tryToClose();

        /** demande quels fichiers modifis il faut sauvegarder */
        bool askForModifiedFilesSave();

        /** charge les parametres par d�faut */
        virtual void loadDefaultParameters();

        /** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();

        /** mets a jour les informations concernant le curseur dans la barre d'etat */
        void updateCursorStatusInfos();

        /** d�fini le panneau central */
        virtual void setCenterPanel(TApplicationPanel * panel, bool bDeleteOld = true);

        /**
         * recherche l'occurence suivante du texte recherche dans l'editeur fourni en parametre
         * @param bRollover peut relancer la recherche depuis le dbut de l'diteur si aucune occurence n'est trouve
         */
        void findNextIn( TCodeEditor * editor, bool bRollover );

        typedef std::map<wxString,TPanelElementInfo> TAvailableEltsList;
        /** cr�e une liste index�e des �l�ments qu'il est possible de mettre dans la fenetre */
        TAvailableEltsList createAvailableElementsInfoList() const;

        /** mets a jour le contenu du menu d'insertion */
        void updateInsertMenu( );

        /** renvoie le r�pertoire utilis� pour le menu d'insertion */
        const wxString & getInsertMenuPath() const { return this->sInsertMenuPath; }
        /** defini le r�pertoire a utiliser pour le menu d'insertion */
        void setInsertMenuPath(const wxString & sPath);

        /**
         * recherche l'existance d'une version plus rcente sur le site web et affiche un avertissement si c'est le cas
         * @param bNoError ne pas afficher de messages d'erreur
         */
        virtual void checkForUpdate(bool bNoError);

        // menu
        void OnFileQuit( wxCommandEvent& event );
        void OnFileNew( wxCommandEvent& event );
        void OnFileOpen( wxCommandEvent& event );
        void OnFileSave( wxCommandEvent& event );
        void OnFileSaveAs( wxCommandEvent& event );
        void OnFileClose( wxCommandEvent& event );
        void OnCloseTab( wxCommandEvent& event );

        void OnEditUndoRedo( wxCommandEvent& event );
        void OnEditCutCopyPaste( wxCommandEvent& event );
        void OnEditSelectAll( wxCommandEvent& event );
        void OnEditJoinLines( wxCommandEvent& event );
        void OnEditDeleteLine( wxCommandEvent& event );
        void OnEditComment( wxCommandEvent& event );
        void OnEditGoToLine( wxCommandEvent& event );
        void OnEditFind( wxCommandEvent& event );
        void OnEditFindSel( wxCommandEvent& event );
        void OnEditFindNext( wxCommandEvent& event );
        void OnEditReplace( wxCommandEvent& event );
        void OnEditPreferences( wxCommandEvent& event );

        void OnInsertReload( wxCommandEvent& event );
        void OnInsertEntry( wxCommandEvent& event );

        void OnNextpeCheckUpdates( wxCommandEvent& event );
        void OnNextpeAbout( wxCommandEvent& event );
        
        enum MenuItems
        {
            // File
            File_Quit = MENU_ID_STATIC_FIRST,
            File_PovNew,
            File_IniNew,
            File_Open,
            File_Recent,
            File_Recent1,
            File_Recent2,
            File_Recent3,
            File_Recent4,
            File_Recent5,
            File_Recent6,
            File_Recent7,
            File_Recent8,
            File_Recent9,
            File_Save,
            File_Save_As,
            File_Close,

            // Edit
            Edit_Undo,
            Edit_Redo,
            Edit_Cut,
            Edit_Copy,
            Edit_Paste,
            Edit_SelectAll,
            Edit_JoinLines,
            Edit_DeleteLine,
            Edit_CommentIn,
            Edit_CommentOut,
            Edit_Gotoline,
            Edit_Find,
            Edit_FindSel,
            Edit_FindNext,
            Edit_Replace,
            Edit_Preferences,

            // Insert
            Insert_Reload,
            Insert_Custom,
        
            // Nextpe
            Nextpe_CheckUpdates,
            Nextpe_About
        };

    protected:
        // ECOUTEURS
        /** indique que le mode de saisie a change */
        virtual void typeModeChanged(TCodeEditor * ce);
        /** indique le curseur s'est d�place */
        virtual void cursorMoved(TCursor * cursor);
        /** indique qu'un element va etre supprime */
        virtual void removingElement(TApplicationPanel * panel, TPanelElement * elt) {};
        /** indique qu'un element est ajoute */
        virtual void addingElement(TApplicationPanel * panel, TPanelElement * elt) {};
        /** indique qu'un element devient visible / cache */
        virtual void elementVisibilityChanged(TApplicationPanel * panel, TPanelElement * elt, bool bVisible);

        /** rempli l'objet menu pass� en param a partir du r�pertoire dont le chemin est le 2nd param */
        void buildInsertMenu(wxMenu * menu, wxString sPath);

        /**
         * cree un nouveau panneau d'edition du type passe en parametre sans lui affecter aucun nom ni le rendre visible
         * @param type type d'editeur a creer
         * @return editeur cree
         */
        FileViewerPanelElement * _createNewFileTab(FileTabType type);
    private:
        typedef std::map<wxString,TPanelElement *> TFilenameToElementMap;
        TFilenameToElementMap openFiles;
        wxFileHistory * filesHistory;
        XPE * application;
        bool bDefaultParametersLoaded;

        // recherche
        SearchDlg * searchDlg;
        ReplaceDlg * replaceDlg;
        bool bModeReplace; // true pour remplacement et false pour recherche simple
        bool bReplaceAll; // true pour ne pas demander de confirmation
        bool bCaseSensitive;
        wxString sSearchPattern;
        wxString sReplaceText;

        wxMenu * menuInsert;
        typedef std::map<long,wxString> TIncludesMap;
        TIncludesMap includes;
        wxString sInsertMenuPath;
};


TApplicationPanel * getMainWindowCenterPanel();


#endif  // _XPE_MAINWINDOW_H_

