/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _PATHS_RESSOURCE_H_
#define _PATHS_RESSOURCE_H_

#include "components/framework/tapplication.h"
#include "lib/commons.h"
#include "lib/lib_string.h"

#include <deque>

class PathsListRes : public TApplicationRessource
{
    public:
        /** donn�es de la liste des chemins */
        struct PathData
        {
            bool bActive;
            wxString sPath;
            PathData(bool b = false, const wxString & s = wxT("")) : bActive(b), sPath(s) {}
            PathData(const PathData & pd) : bActive(pd.bActive), sPath(pd.sPath) {}
        };
        /** une liste de chaines de caract�res */
        typedef std::deque<PathData> TPathsList;


        PathsListRes() {}
        virtual ~PathsListRes() {}

        /** Ajoute un chemin � la liste des chemins de recherche ou en change la priorit� */
        void addPath(const wxString & sPath, bool bActive, uint iPriority = -1);
        /** supprime un chemin de la liste de recherche */
        void removePath(const wxString & sPath);
        /** efface toute la liste */
        void clear();

        /** renvoie une r�f�rence sur la liste des chemins interne */
        TPathsList getPathsList() const { return this->paths; }

        /** renvoie le chemin complet jusqu'� un fichier
         * @returns "" si le fichier n'a pas pu etre trouv�
         */
        wxString getAbsoluteFilePath(const wxString & sRelativeFile) const { return this->getAbsoluteFilePath(sRelativeFile,wxT("")); }

        /**
         * renvoie le chemin complet jusqu'� un fichier
         * @param sRelativeFile nom de fichier relatif
         * @param sExecutionPath chemin d'execution du rendu : il est prioritaire sur les chemins de librairies
         * @returns "" si le fichier n'a pas pu etre trouv�
         */
        wxString getAbsoluteFilePath(const wxString & sRelativeFile, const wxString sExecutionPath) const;

        /** normalise le chemin pass� en param�tre */
        static wxString normalizePath(const wxString & sPath, bool bDirectory = true);

    protected:

        /** renvoie un iterator sur le premier chemin equivalent � sPath */
        TPathsList::iterator findFirst(const wxString & sPath);

    private:
        /** renvoie un iterator sur le premier chemin egal � sPath */
        TPathsList::iterator _findFirst(const wxString & sNormalizedPath);

        TPathsList paths;
};

#endif // _PATHS_RESSOURCE_H_
