/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _IMAGEVIEWER_PANEL_ELEMENT_H_
#define _IMAGEVIEWER_PANEL_ELEMENT_H_

#include <wx/event.h>
#include <wx/string.h>

#include "lib/commons.h"
#include "components/framework/tpanelelement.h"
#include "components/stdgui/tgenbuttonlistener.h"
#include "xpe_components/filepelt/file_panelelement.h"
#include "components/stdgui/tbitmap.h"

class TImageViewer;
class TGenButton;
class wxStaticText;

#define PELT_TYPE_IMAGEVIEWER "PELT_TYPE_IMAGEVIEWER"

/**
 * @short Un element de panneau d'application affichant une image
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ImageViewerPanelElement : public FileViewerPanelElement, protected TGenButtonListener
{
    TRANSLATABLE;
    public:
        ImageViewerPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ImageViewerPanelElement();

        /** indique si le composant doit etre sauvegarde dans la config en XML */
        virtual bool mightBeSaved() const { return false; }

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_IMAGEVIEWER; }

    protected:
        /** charge un fichier apres avoir vidange le contenu du composant */
        virtual bool loadFileImpl(const wxString & sFile);

        /** ecris un fichier */
        virtual bool writeFileImpl(const wxString & sFile);

        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        /** un bouton a ete active */
        virtual void buttonActivated(TGenButton * btn);
        /** un bouton a ete bascule */
        virtual void buttonToggled(TGenButton * btn);

        /** mets a jour les infos de zoom */
        void updateZoomInfos();

    private:
        TImageViewer * imageViewer;
        TBitmap * bmp;
        TGenButton * btnZoomIn;
        TGenButton * btnZoomOut;
        TGenButton * btnAdjustZoom;
        wxStaticText * lblZoom;
        TGenButton * btnOpenExternaly;
        bool bUpdatingZoom;
};

#endif // _IMAGEVIEWER_PANEL_ELEMENT_H_
