/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _FILEVIWER_PANEL_ELEMENT_H_
#define _FILEVIWER_PANEL_ELEMENT_H_

#include <wx/event.h>
#include <wx/string.h>

#include "lib/commons.h"
#include "components/framework/tpanelelement.h"

/**
 * @short Un element de visualisation de fichier
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class FileViewerPanelElement : public TPanelElement, public wxObject
{
    public:
        FileViewerPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~FileViewerPanelElement();

        /** charge un fichier apres avoir vidange le contenu du composant */
        bool loadFile(const wxString & sFile);

        /** ecris un fichier */
        bool writeFile(const wxString & sFile);

        /** ecris les modifs du fichier */
        bool writeFile();

        /** defini le nom du panel en fonction du nom du fichier affiche */
        virtual void setFilename(const wxString & sFile);

        /** nom du fichier */
        virtual const wxString & getFilename() { return this->sFilename; }

        /** nom du fichier */
        virtual wxString getFilename() const { return this->sFilename; }

        /** indique si le composant a ete modifie */
        bool isModified() const { return this->bModified; }

        /** defini si le composant a ete modifie */
        virtual void setModified(bool b);

        /** indique si le composant doit etre sauvegarde dans le fichier de config */
        virtual bool mightBeSaved() const { return false; }

        /** defini les image pour l'etat modifie / non-modifie du composant */
        virtual void setBitmaps(const TBitmap * bmpNormal, const TBitmap * bmpModified);

        /** renvoie la date / heure de derniere modification du document. */
        virtual long getLastModificationTime() const { return this->iLastModificationTime; }

        /** indique si il faut ajouter une croix de fermeture sur l'onglet */
        virtual bool mightShowClosingCross() const { return true; }

        /** demande la fermeture du panneau */
        virtual void doCloseElement();

        /** indique si il est possible d'afficher un titre pour le panneau */
        virtual bool mightShowTitleBar() const { return false; }

    protected:
        /** ecris un fichier */
        virtual bool writeFileImpl(const wxString & sFile) = 0;

        /** charge un fichier apres avoir vidange le contenu du composant */
        virtual bool loadFileImpl(const wxString & sFile) = 0;

    private:
        wxString sFilename;
        bool bModified;
        long iLastModificationTime;
        const TBitmap * bmpNormal;
        const TBitmap * bmpModified;
};

#endif // _FILEVIWER_PANEL_ELEMENT_H_
