/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES                                 *
 *   thierry@les-charles.net                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _POV_ENLIGHTER_H_
#define _POV_ENLIGHTER_H_

#include "components/codeeditor/tenlighter.h"
#include "lib/lib_string.h"
#include "lib/commons.h"

#include "xpe_components/editor/editor_styles.h"

typedef std::deque<int> TIntList;

class PovEnlighter : public TEnlighter
{
    public:
        PovEnlighter(TCodeEditor * editor, TStringList * _keywords = NULL) : TEnlighter(editor), keywords(_keywords) {}
        virtual ~PovEnlighter(){}

        /** indique si un indentifiant est un mot cl */
        virtual bool isKeyword(const wxString & sWord) const;

    protected:
        /**
         * dfinis tout au style par dfaut
         * ne pas appeler directement
         * @param iLine ligne a colorer
         * @param iPreviousLineEndState tat dans lequel se trouvait l'analyseur lors de la sortie de cette fonction pour la ligne prcdente. La premire ligne (0) est appelle avec 0.
         * @param info informations de mise en valeur a complter.
         * @return tat de l'analyseur  utiliser pour la ligne suivante.
         */
        virtual int enlightLine(int iLine, int iPreviousLineEndState, TLineEnlightenmentInformation & info);

        /** signale l'insertion de texte dans le document. */
        virtual void documentTextInserted(TDocument * doc, const TPoint & ptFrom, const TPoint & ptTo);
        /** signale la suppression de texte dans le document. */
        virtual void documentTextRemoved(TDocument * doc, const TPoint & ptFrom, const TPoint & ptTo);
        /** signale de grosses modifs sur le document. puis appelle documentChanged */
        virtual void documentHeavilyModified(TDocument * doc);

        /** renvoie un itrateur sur une ligne */
        TIntList::iterator getCommentInfoLineIterator(uint iLine);

    private:
        TStringList * keywords;
        TIntList commentLevels;
};

#endif
