/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "keywordsres.h"

#include <wx/txtstrm.h>
#include <wx/wfstream.h>


/** dfini le fichier a utiliser pour la liste de mots cl */
void KeywordsListRes::setKeywordsFile(const wxString & sFile)
{
    if(sFile == this->sFile)
        return;

    this->sFile = sFile;

    this->keywords.erase(this->keywords.begin(),this->keywords.end());

    if(sFile.length())
    {
        wxFFileInputStream input(sFile,wxT("r"));
        if(!input.Ok())
            return;
    
        wxTextInputStream reader(input);
    
        while(!input.Eof())
        {
            wxString sKeyword = reader.ReadLine().Trim();
            if(sKeyword.length())
            {
                this->keywords.push_back(sKeyword);
            }
        }
    }

    this->fireRessourceEvent(1);
}
