/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ini_panelelement.h"
#include "components/codeeditor/tcodeeditor.h"
#include "editor_styles.h"
#include "ini_enlighter.h"
#include "xpe_components/res_id.h"
#include "keywordsres.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/framework/tmainwindow.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"

#include "bmp_id.h"

#include "lib/lib_logging.h"

IniPanelElement::IniPanelElement(TApplicationPanel * _owner, int iID)
    : EditorPanelElement(_owner, iID)
{
    this->setName(wxTr("New Ini File"));
    this->setBitmaps(GET_BMP(BMP_FILE_INI_ID),GET_BMP(BMP_FILE_INI_M_ID));
}

IniPanelElement::~IniPanelElement()
{
}


/** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
TPanel * IniPanelElement::buildContentPanel()
{
    TPanel * panel = EditorPanelElement::buildContentPanel( false );
    TCodeEditor * editor = this->getEditor();

    KeywordsListRes * keywords = static_cast<KeywordsListRes *>(CurrentApplication()->getRessource(INI_KEYWORDS_LIST_RESSOURCE_ID));
    TStringList * keywordsList = NULL;
    if(keywords)
        keywordsList = keywords->getKeywordsList();
    editor->setEnlighter(new IniEnlighter(editor,keywordsList));

    this->setKeywordsListRes( keywords );

    return panel;
}
