/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _SEARCH_DLG_H_
#define _SEARCH_DLG_H_

#include <wx/dialog.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/string.h>

#include <deque>

#include "lib/commons.h"
#include "components/framework/translation.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"


/** Dialogue de fermeture de l'appli permettant de choisir les fichiers a sauvegarder */
class SearchDlg : public wxDialog, virtual public TranslatableCmp, public TGenButtonListener
{
    TRANSLATABLE;
    public:
        SearchDlg(wxWindow * owner);
        virtual ~SearchDlg() {}

        /**
         * affiche le dialogue de recherche
         * @param sInitialSearch valeur recherch�e
         * @return false si annule
         */
        bool show(const wxString & sInitialSearch);

        /**
         * affiche le dialogue de recherche
         * @return false si annule
         */
        bool show();

        /**
         * renvoie la chaine qu'il faut rechercher
         */
        wxString getSearchString();

        /**
         * indique si la recherche est sensible a la casse
         */
        bool isCaseSensitive();

        /** validation clavier */
        void onKeyboardEvent(wxKeyEvent & evt);
        
        virtual void buttonActivated(TGenButton * btn);
        
    private:
        DECLARE_EVENT_TABLE();

        wxTextCtrl * searchField;
        wxCheckBox * caseSensitiveChk;

        TGenButton * btnOk;
        TGenButton * btnCancel;
};


#endif
