/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _MISC_CFG_H_
#define _MISC_CFG_H_

#include <wx/stattext.h>
#include "lib/commons.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"

#include "components/framework/tconfigdlg.h"

#define PELT_TYPE_MISC_CONFIG "PELT_TYPE_MISC_CONFIG"

class XPEMainWindow;
class wxTextCtrl;

class MiscConfigPanelElement : public TConfigPanelElement, protected TGenButtonListener
{
    TRANSLATABLE;
    public:
        MiscConfigPanelElement(XPEMainWindow * _mainWindow, TApplicationPanel * _owner, int iID = -1);
        virtual ~MiscConfigPanelElement() {}

        /** initialise le panneau avec les parametres actuels de l'application */
        virtual void init();

        /** valide les modifications */
        virtual void commit();

        /** indique si le panneau est dans un �tat valide */
        virtual bool canCommit();

        /** renvoie une constante identifiant le type de cet �l�ment de mani�re a pouvoir le reconstruire lors du chargement des pr�f�rences */
        virtual const char * getElementType() const { return PELT_TYPE_MISC_CONFIG; }

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        virtual void buttonActivated(TGenButton * btn);
        virtual void buttonToggled(TGenButton * btn){}

    private:
        XPEMainWindow * mainWindow;
        TPanel * contentPanel;
        TGenButton * reinitBtn;
        wxStaticText * insertErrorLabel;
        wxTextCtrl * insertPathField;
        TGenButton * insertPathChooserBtn;
        wxStaticText * languageErrorLabel;
        wxTextCtrl * languageFileField;
        TGenButton * languageFileChooserBtn;
        TGenButton * downloadLanguageFileBtn;
};

#endif

