/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "misc_cfg.h"

#include <wx/filename.h>
#include <wx/dirdlg.h>
#include <wx/filedlg.h>

#include "components/framework/tapplication.h"
#include "components/framework/tapplicationpanel.h"
#include "components/stdgui/tbitmap.h"

#include "lib/lib_file.h"
#include "lib/lib_logging.h"

#include "xpe_components/mainwindow.h"

#include "xpe.h"

#include "bmp_id.h"

MiscConfigPanelElement::MiscConfigPanelElement(XPEMainWindow * _mainWindow, TApplicationPanel * _owner, int iID)
    :TConfigPanelElement(_owner, (iID < 0) ? static_cast<XPE *>(CurrentApplication())->getUPEID() : iID),
    mainWindow(_mainWindow),
    contentPanel(NULL),
    reinitBtn(NULL),
    insertErrorLabel(NULL),
    insertPathField(NULL),
    insertPathChooserBtn(NULL),
    languageErrorLabel(NULL),
    languageFileField(NULL),
    languageFileChooserBtn(NULL),
    downloadLanguageFileBtn(NULL)
{
    this->setName(wxTr("Misc."));
}

void MiscConfigPanelElement::buttonActivated(TGenButton * btn)
{
    if(btn == this->reinitBtn)
    {
        this->init();
    }
    else if(btn == this->insertPathChooserBtn)
    {
        wxDirDialog * dlg = new wxDirDialog(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()), wxTr("Choose insert-menu directory"), this->insertPathField->GetValue());
        int iRes = dlg->ShowModal();
        if(iRes == wxID_OK)
        {
            this->insertPathField->SetValue(dlg->GetPath());
            this->canCommit();
        }
        delete dlg;
    }
    else if(btn == this->languageFileChooserBtn)
    {
        wxFileDialog * dlg = new wxFileDialog(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()), wxTr("Choose the file containing the translation"), libfile::dirname(this->languageFileField->GetValue()), wxT(""), wxT("*"),wxOPEN|wxFILE_MUST_EXIST);
        int iRes = dlg->ShowModal();
        if(iRes == wxID_OK)
        {
            this->languageFileField->SetValue(dlg->GetPath());
            this->canCommit();
        }
        delete dlg;
    }
    else if (btn == this->downloadLanguageFileBtn)
    {
        wxString sUrl(wxT("http://nextpe.sf.net?id=3"));
        wxLaunchDefaultBrowser(sUrl);
    }
}

/** initialise le panneau avec les parametres actuels de l'application */
void MiscConfigPanelElement::init()
{
    this->insertPathField->SetValue(this->mainWindow->getInsertMenuPath());
    this->languageFileField->SetValue(static_cast<XPE *>(CurrentApplication())->getTranslationFile());
    this->canCommit();
}

/** valide les modifications */
void MiscConfigPanelElement::commit()
{
    this->mainWindow->setInsertMenuPath(this->insertPathField->GetValue());
    if(this->languageFileField->GetValue() != static_cast<XPE *>(CurrentApplication())->getTranslationFile())
    {
        static_cast<XPE *>(CurrentApplication())->setTranslationFile(this->languageFileField->GetValue());
        wxMessageBox(wxTr("Changing the language file requires to reload application to be taken into account"),wxTr("Warning"));
    }
}

/** indique si le panneau est dans un tat valide */
bool MiscConfigPanelElement::canCommit()
{
    bool b1 = true;
    if(this->insertPathField->GetValue().length())
    {
        b1 = libfile::isDirectory(this->insertPathField->GetValue());
        if(!b1)
            this->insertErrorLabel->SetLabel(wxTr("Directory does not exist"));
        else
            this->insertErrorLabel->SetLabel(wxT(""));
    }
    bool b2 = true;
    if(this->languageFileField->GetValue().length())
    {
        b2 = libfile::isFile(this->languageFileField->GetValue());
        if(!b2)
            this->languageErrorLabel->SetLabel(wxTr("File does not exist"));
        else
            this->languageErrorLabel->SetLabel(wxT(""));
    }
    this->contentPanel->GetSizer()->Layout();
    return b1 && b2;
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * MiscConfigPanelElement::buildContentPanel()
{
    if(this->contentPanel)
        return this->contentPanel;

    this->contentPanel = new TPanel(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()));
    wxBoxSizer * mainSizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(mainSizer);

    mainSizer->AddSpacer(5);

    this->reinitBtn = new TGenButton(this->contentPanel);
    this->reinitBtn->setBitmap( GET_BMP(BMP_REFRESH_ID) );
    this->reinitBtn->setText(wxTr("Reload"));
    this->reinitBtn->addButtonListener( this );
    mainSizer->Add(this->reinitBtn,0,wxALIGN_RIGHT|wxLEFT|wxRIGHT,5);

    // Chemin du menu d'insertion
    wxStaticText * label = new wxStaticText(this->contentPanel,-1,wxTr("Insert-menu path :"));
    mainSizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    TPanel * panel = new TPanel(this->contentPanel);
    wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
    this->insertPathField = new wxTextCtrl(panel, -1);
    sizer->Add(this->insertPathField,1,wxEXPAND);
    sizer->AddSpacer(3);
    this->insertPathChooserBtn = new TGenButton(panel);
    this->insertPathChooserBtn->setBitmap( GET_BMP(BMP_FILE_OPEN_ID) );
    this->insertPathChooserBtn->addButtonListener( this );
    sizer->Add(this->insertPathChooserBtn,0,wxEXPAND);
    panel->SetSizer(sizer);
    mainSizer->Add(panel,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    this->insertErrorLabel = new wxStaticText(this->contentPanel, -1, wxT(""));
    mainSizer->Add(this->insertErrorLabel,0,wxALIGN_CENTER|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(5);

    
    // fichier de langue
    label = new wxStaticText(this->contentPanel,-1,wxTr("Translation file :"));
    mainSizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    panel = new TPanel(this->contentPanel);
    sizer = new wxBoxSizer( wxHORIZONTAL );
    this->languageFileField = new wxTextCtrl(panel, -1);
    sizer->Add(this->languageFileField,1,wxEXPAND);
    sizer->AddSpacer(3);
    this->languageFileChooserBtn = new TGenButton(panel);
    this->languageFileChooserBtn->setBitmap( GET_BMP(BMP_FILE_OPEN_ID) );
    this->languageFileChooserBtn->addButtonListener( this );
    sizer->Add(this->languageFileChooserBtn,0,wxEXPAND);
    panel->SetSizer(sizer);
    mainSizer->Add(panel,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);
 
    this->languageErrorLabel = new wxStaticText(this->contentPanel, -1, wxT(""));
    mainSizer->Add(this->languageErrorLabel,0,wxALIGN_CENTER|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);
    
    this->downloadLanguageFileBtn = new TGenButton(this->contentPanel);
    this->downloadLanguageFileBtn->setText(wxTr("Download language files from http://nextpe.sf.net"));
    this->downloadLanguageFileBtn->addButtonListener( this );
    mainSizer->Add(this->downloadLanguageFileBtn,0,wxCENTER|wxLEFT|wxRIGHT,5);
    
    mainSizer->AddSpacer(5);

    
    mainSizer->AddStretchSpacer(10);

    return this->contentPanel;
}

