/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _MAINWINDOW_CFG_H_
#define _MAINWINDOW_CFG_H_

#include "components/stdgui/tlistctrl.h"
#include <wx/combobox.h>
#include <wx/stattext.h>
#include <wx/string.h>
#include <wx/imaglist.h>

#include <map>
#include <set>

#include "lib/commons.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"

#include "components/framework/tconfigdlg.h"
#include "components/framework/elementinfo.h"

class XPEMainWindow;
class TApplicationPanel;

#define PELT_TYPE_MAINWINDOW_CONFIG "PELT_TYPE_MAINWINDOW_CONFIG"

class MainWindowConfigPanelElement : public TConfigPanelElement, protected TGenButtonListener, protected wxEvtHandler
{
    TRANSLATABLE;
    public:
        MainWindowConfigPanelElement(XPEMainWindow * mainWindow, TApplicationPanel * _owner, int iID = -1);
        virtual ~MainWindowConfigPanelElement() {}

        /** initialise le panneau avec les parametres actuels de l'application */
        virtual void init();

        /** valide les modifications */
        virtual void commit();

        /** indique si le panneau est dans un �tat valide */
        virtual bool canCommit();

        /** renvoie une constante identifiant le type de cet �l�ment de mani�re a pouvoir le reconstruire lors du chargement des pr�f�rences */
        virtual const char * getElementType() const { return PELT_TYPE_MAINWINDOW_CONFIG; }

        struct EltMetaInf
        {
            explicit EltMetaInf(const char * szType = NULL, wxString sName = wxT("Unknown element"), int iDisplayOrder = -1, int iID = -1, TApplicationPanel * origin = NULL);
            const char * szType;
            wxString sName;
            int iDisplayOrder;
            int iID;
            TApplicationPanel * origin;
        };

        typedef std::set<EltMetaInf> TEltsMetaList;

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        virtual void buttonActivated(TGenButton * btn);
        virtual void buttonToggled(TGenButton * btn){}

        void onComboBox(wxCommandEvent & evt);
        void onListViewSize(wxSizeEvent & evt);

        /** initialise les metas donnees concernant un panneau */
        void initPanel(const wxString & sPanel, TApplicationPanel * panel);

        /** mets a jour l'affichage */
        void updatePanel();

        /** enleve les elements qui ont �t� supprim�s */
        void commitPanelEltsDeletion(TApplicationPanel * panel, const std::set<int> & idsList);
        /** cr�e / trans�re les elements ajout�s / conserv�s */
        void commitPanelElts(TApplicationPanel * panel, const TEltsMetaList & eltsList);

    private:
        XPEMainWindow * mainWindow;
        TPanel * contentPanel;
        TGenButton * reinitBtn;
        wxComboBox * panelCombo;
        wxComboBox * elementsCombo;
        TGenButton * addBtn;
        TGenButton * renameBtn;
        TGenButton * changePanelBtn;
        TGenButton * removeBtn;
        TListCtrl * selectedElementsList;
        wxImageList imagesList;
        TGenButton * moveUpBtn;
        TGenButton * moveDownBtn;

        typedef std::map<wxString,TPanelElementInfo> TAvailableEltsList;
        TAvailableEltsList availableElts;
        typedef std::map<wxString,int> TEltsIconIdxMap;
        TEltsIconIdxMap eltsIconMap;
        typedef std::map<wxString, TPanelElementInfo *> TAvailableEltsTypeList;
        TAvailableEltsTypeList availableEltsByType;

        wxString sTopPanel;
        wxString sLeftPanel;
        wxString sRightPanel;
        wxString sBottomPanel;

        typedef std::map<wxString,TEltsMetaList> TPanelEltsMap;
        TPanelEltsMap panelEltsMap;
};

bool operator <  (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);
bool operator >  (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);
bool operator <= (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);
bool operator >= (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);
bool operator == (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);
bool operator != (const MainWindowConfigPanelElement::EltMetaInf &A,const MainWindowConfigPanelElement::EltMetaInf &B);

#endif

