/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "keywords_cfg.h"

#include <wx/filename.h>
#include <wx/filedlg.h>

#include "components/framework/tapplication.h"
#include "components/framework/tapplicationpanel.h"
#include "components/stdgui/tbitmap.h"
#include "xpe_components/res_id.h"
#include "xpe_components/editor/keywordsres.h"
#include "lib/lib_file.h"

#include "xpe.h"

#include "bmp_id.h"

KeywordsConfigPanelElement::KeywordsConfigPanelElement(TApplicationPanel * _owner, int iID)
    :TConfigPanelElement(_owner, (iID < 0) ? static_cast<XPE *>(CurrentApplication())->getUPEID() : iID),
    contentPanel(NULL),
    reinitBtn(NULL),
    povErrorLabel(NULL),
    povFileField(NULL),
    povFileChooserBtn(NULL),
    iniErrorLabel(NULL),
    iniFileField(NULL),
    iniFileChooserBtn(NULL)
{
    this->setName(wxTr("Keywords"));
}

void KeywordsConfigPanelElement::buttonActivated(TGenButton * btn)
{
    if(btn == this->reinitBtn)
    {
        this->init();
    }
    else if(btn == this->povFileChooserBtn)
    {
        wxFileDialog * dlg = new wxFileDialog(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()), wxTr("Choose the file containing povray keywords"), libfile::dirname(this->povFileField->GetValue()) , wxT(""), wxT("*"),wxOPEN|wxFILE_MUST_EXIST);
        int iRes = dlg->ShowModal();
        if(iRes == wxID_OK)
        {
            this->povFileField->SetValue(dlg->GetPath());
            this->canCommit();
        }
        delete dlg;
    }
    else if(btn == this->iniFileChooserBtn)
    {
        wxFileDialog * dlg = new wxFileDialog(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()), wxTr("Choose the file containing ini keywords"), libfile::dirname(this->iniFileField->GetValue()), wxT(""), wxT("*"),wxOPEN|wxFILE_MUST_EXIST);
        int iRes = dlg->ShowModal();
        if(iRes == wxID_OK)
        {
            this->iniFileField->SetValue(dlg->GetPath());
            this->canCommit();
        }
        delete dlg;
    }
}

/** initialise le panneau avec les parametres actuels de l'application */
void KeywordsConfigPanelElement::init()
{
    KeywordsListRes * keywords = static_cast<KeywordsListRes *>(CurrentApplication()->getRessource(POV_KEYWORDS_LIST_RESSOURCE_ID));
    if(keywords)
    {
        this->povFileField->SetValue(keywords->getKeywordsFile());
        this->canCommit();
    }
    else
    {
        this->povFileField->SetValue(wxTr("Unable to find the keywords ressource."));
    }
    keywords = static_cast<KeywordsListRes *>(CurrentApplication()->getRessource(INI_KEYWORDS_LIST_RESSOURCE_ID));
    if(keywords)
    {
        this->iniFileField->SetValue(keywords->getKeywordsFile());
        this->canCommit();
    }
    else
    {
        this->iniFileField->SetValue(wxTr("Unable to find the keywords ressource."));
    }
}

/** valide les modifications */
void KeywordsConfigPanelElement::commit()
{
    KeywordsListRes * keywords = static_cast<KeywordsListRes *>(CurrentApplication()->getRessource(POV_KEYWORDS_LIST_RESSOURCE_ID));
    if(!keywords)
    {
        keywords = new KeywordsListRes();
        CurrentApplication()->publishRessource(POV_KEYWORDS_LIST_RESSOURCE_ID,keywords);
    }

    keywords->setKeywordsFile(this->povFileField->GetValue());

    keywords = static_cast<KeywordsListRes *>(CurrentApplication()->getRessource(INI_KEYWORDS_LIST_RESSOURCE_ID));
    if(!keywords)
    {
        keywords = new KeywordsListRes();
        CurrentApplication()->publishRessource(INI_KEYWORDS_LIST_RESSOURCE_ID,keywords);
    }

    keywords->setKeywordsFile(this->iniFileField->GetValue());
}

/** indique si le panneau est dans un tat valide */
bool KeywordsConfigPanelElement::canCommit()
{
    bool b = true;
    if(this->povFileField->GetValue().length())
    {
        b = wxFileName::FileExists(this->povFileField->GetValue());
        if(!b)
            this->povErrorLabel->SetLabel(wxTr("File does not exist"));
        else
            this->povErrorLabel->SetLabel(wxT(""));
    }

    if(this->iniFileField->GetValue().length())
    {
        b = wxFileName::FileExists(this->iniFileField->GetValue());
        if(!b)
            this->iniErrorLabel->SetLabel(wxTr("File does not exist"));
        else
            this->iniErrorLabel->SetLabel(wxT(""));
    }

    this->contentPanel->GetSizer()->Layout();
    return b;
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * KeywordsConfigPanelElement::buildContentPanel()
{
    if(this->contentPanel)
        return this->contentPanel;

    this->contentPanel = new TPanel(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()));
    wxBoxSizer * mainSizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(mainSizer);

    mainSizer->AddSpacer(5);

    this->reinitBtn = new TGenButton(this->contentPanel);
    this->reinitBtn->setBitmap( GET_BMP(BMP_REFRESH_ID) );
    this->reinitBtn->setText(wxTr("Reload"));
    this->reinitBtn->addButtonListener( this );
    mainSizer->Add(this->reinitBtn,0,wxALIGN_RIGHT|wxLEFT|wxRIGHT,5);

    wxStaticText * label = new wxStaticText(this->contentPanel,-1,wxTr("Povray's keywords list :"));
    mainSizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    TPanel * panel = new TPanel(this->contentPanel);
    wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
    this->povFileField = new wxTextCtrl(panel, -1);
    sizer->Add(this->povFileField,1,wxEXPAND);
    sizer->AddSpacer(3);
    this->povFileChooserBtn = new TGenButton(panel);
    this->povFileChooserBtn->setBitmap( GET_BMP(BMP_FILE_OPEN_ID) );
    this->povFileChooserBtn->addButtonListener( this );
    sizer->Add(this->povFileChooserBtn,0,wxEXPAND);
    panel->SetSizer(sizer);
    mainSizer->Add(panel,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    this->povErrorLabel = new wxStaticText(this->contentPanel, -1, wxT(""));
    mainSizer->Add(this->povErrorLabel,0,wxALIGN_CENTER|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(5);

    label = new wxStaticText(this->contentPanel,-1,wxTr("Ini's keywords list :"));
    mainSizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    panel = new TPanel(this->contentPanel);
    sizer = new wxBoxSizer( wxHORIZONTAL );
    this->iniFileField = new wxTextCtrl(panel, -1);
    sizer->Add(this->iniFileField,1,wxEXPAND);
    sizer->AddSpacer(3);
    this->iniFileChooserBtn = new TGenButton(panel);
    this->iniFileChooserBtn->setBitmap( GET_BMP(BMP_FILE_OPEN_ID) );
    this->iniFileChooserBtn->addButtonListener( this );
    sizer->Add(this->iniFileChooserBtn,0,wxEXPAND);
    panel->SetSizer(sizer);
    mainSizer->Add(panel,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    this->iniErrorLabel = new wxStaticText(this->contentPanel, -1, wxT(""));
    mainSizer->Add(this->iniErrorLabel,0,wxALIGN_CENTER|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(5);

    mainSizer->AddStretchSpacer(10);

    return this->contentPanel;
}

