#ifndef _XPE_H_
#define _XPE_H_

#include <wx/wx.h>

#include "lib/commons.h"
#include "components/framework/tapplication.h"

class wxSplashScreen;

/**
 * @short neXt Povray Editor Application
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class XPE : public TApplication
{
    TRANSLATABLE;
    public:
        XPE();
        virtual ~XPE();

        virtual bool start();

        /**
         * Effectue les traitements de fermeture de l'application. N'est pas appel� si "bool start()" renvoie false
         */
        virtual void stop();

        /** renvoie un identifiant unique d'element */
        int getUPEID();

        /**
         * cree une instance de l'element dont le type est passe en parametre et l'ajoute au panneau parent. Le type doit correspondre au type renvoye par TPanelElement::getType
         */
        virtual TPanelElement * builElement(const char * szType, TApplicationPanel * _owner, int iID);

        /** charge les parametres par defaut */
        virtual void loadDefaultParameters();
        /** charge les parametres du composant a partir des informations contenues dans le noeud passe en parametre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();

        /** dclare que l'init de l'application est termin */
        virtual void applicationStarted();
        /** declare que l'init de l'application est termine en erreur */
        virtual void applicationStartupFailed();

        /** renvoie le repertoire d'installation du programme */
        const wxString & getInstallPrefix() const { return this->sInstallPrefix; }
        /** renvoie le repertoire d'installation de povray */
        const wxString & getPovrayInstallPath() const { return this->sPovrayInstallPath; }

    protected:
        /** construit la fenetre principale et en renvoie le pointeur */
        virtual TMainWindow * buildMainWindow();

    private:
        /** initialise les bitmaps de l'appli */
        void initBmps();
        wxSplashScreen * splash;
        wxString sInstallPrefix;
        wxString sPovrayInstallPath;
};

#endif // _XPE_H_
