#!/bin/bash

PROC="$0"
SUB="$1"

FirstChar="`echo "${PROC}" | cut -c1`"
if [ ${FirstChar} != "/" ] 
then
    PROC="`pwd`/${PROC}"
fi



for i in *
do
    if [ -d "$i" ]
    then
        cd "$i"
    
        rm -f Makefile*
        touch Makefile.am
        
        SUBDIRS=""
        FILES=""
        for j in *
        do
            j2=`echo "$j" | tr "[\ \(\)]" "_"`
            if [ "$j" != "$j2" ]
            then
                mv "$j" "$j2"
                j=$j2
            fi
        done
            
        for j in *
        do
            if [ -d "$j" ]
            then
                SUBDIRS="${SUBDIRS} `echo "${j}" | tr " " "#"`"
                ${PROC} "${SUB}/${i}"
            else
                if [ "${j}" != "Makefile.am" ]
                then
                    FILES="${FILES} `echo "${j}" | tr " " "#"`"
                fi
            fi
        done
        if [ "${SUBDIRS}" != "" ]
        then
            echo "SUBDIRS = ${SUBDIRS}" >> Makefile.am
        fi
        
        if [ "$FILES" != "" ]
        then
            echo "filesdir = \$(pkgdatadir)/Insert_Menu/${SUB}/${i}" >> Makefile.am
            echo "files_DATA = ${FILES}" >> Makefile.am
        fi
        cd ..
    fi 
done
