/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TPROCESS_H_
#define _STDGUI_TPROCESS_H_

#include <wx/process.h>
#include "lib/commons.h"
#include "lib/lib_string.h"

class TProcess
{
    public:
        TProcess() : iPID(-1), iExitCode(-1), process(NULL) {}
        virtual ~TProcess() {}

        /** d�fini la ligne de commande a ex�cuter */
        void setCommandLine(const wxString & sCommandLine);
        /** renvoie la ligne de commande utilis�e pour le process */
        const wxString & getCommandLine() const { return this->sCommandLine; }

        /** d�fini le r�pertoire de travail dans lequel le process sera execut� */
        void setWorkingDirectory(const wxString & sWorkingDir);
        /** renvoie le r�pertoire dans lequel la commande sera ex�cut�e */
        const wxString & getWorkingDirectory() const { return this->sWorkingDir; }

        /** renvoie le PID du process */
        int getPID() { return this->iPID; }

        /** indique si le process est en cours d'ex�cution */
        bool isRunning();

        /** d�marre le process */
        bool start();

        /** arrete le process */
        bool stop(bool bForce);

        /** renvoie le code de retour du process */
        int getExitCode() { return this->iExitCode; }

        bool isErrorAvailable() const;
        bool isOutputAvailable() const;
        wxString GetErrorData();
        wxString GetOutputData();

    private:

        class InternalProcess : public wxProcess
        {
            public:
                InternalProcess(TProcess * _owner) : wxProcess(wxPROCESS_REDIRECT), owner(_owner) {}
                virtual ~InternalProcess() {}
                /** It is called when the process with the pid pid finishes */
                virtual void OnTerminate(int pid, int status);
            private:
                TProcess * owner;
        };

        friend class InternalProcess;

        wxString sCommandLine;
        wxString sWorkingDir;
        int iPID;
        int iExitCode;
        InternalProcess * process;
        wxString errorBuffer;
        wxString outputBuffer;
};


#endif // _STDGUI_TPROCESS_H_
