/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TCOLOR_H_
#define _TCOLOR_H_

#include "lib/commons.h"
#include <wx/colour.h>

#define TCOLOR_CHANNEL_MAXVALUE 255.0
class TColor
{
    public :
        TColor() : bRGBIsSet(true), iRed(0), iGreen(0), iBlue(0), bHSVIsSet(true), iHue(0), iSaturation(255), iValue(0) {}
        TColor(uint r, uint g, uint b) : bRGBIsSet(true), iRed(r), iGreen(g), iBlue(b), bHSVIsSet(false), iHue(0), iSaturation(0), iValue(0) { this->ensureHSVIsSet(); }
        TColor(const wxColour * colour) : bRGBIsSet(true), iRed(0), iGreen(0), iBlue(0), bHSVIsSet(false), iHue(0), iSaturation(0), iValue(0) { if(colour) this->initFrom(colour); }
        TColor(const wxColour & colour) : bRGBIsSet(true), iRed(0), iGreen(0), iBlue(0), bHSVIsSet(false), iHue(0), iSaturation(0), iValue(0) { this->initFrom(colour); }

        /** renvoie la valeur "rouge" */
        uint getRed() const;
        /** renvoie la valeur "vert" */
        uint getGreen() const;
        /** renvoie la valeur "bleu" */
        uint getBlue() const;

        /** renvoie la valeur "rouge" dans un triplet ou aucune des valeurs ne dpasse 255 */
        uint getNormalizedRed() const;
        /** renvoie la valeur "vert" dans un triplet ou aucune des valeurs ne dpasse 255 */
        uint getNormalizedGreen() const;
        /** renvoie la valeur "bleu" dans un triplet ou aucune des valeurs ne dpasse 255 */
        uint getNormalizedBlue() const;

        /** renvoie la valeur "rouge" en notation dcimale */
        float getDecimalRed() const;
        /** renvoie la valeur "vert" en notation dcimale */
        float getDecimalGreen() const;
        /** renvoie la valeur "bleu" en notation dcimale */
        float getDecimalBlue() const;

        /** renvoie la valeur "rouge" en notation dcimale dans un triplet ou aucune des valeurs ne dpasse 1.0 */
        float getNormalizedDecimalRed() const;
        /** renvoie la valeur "vert" en notation dcimale dans un triplet ou aucune des valeurs ne dpasse 1.0 */
        float getNormalizedDecimalGreen() const;
        /** renvoie la valeur "bleu" en notation dcimale dans un triplet ou aucune des valeurs ne dpasse 1.0 */
        float getNormalizedDecimalBlue() const;

        /** applique un ratio a la couleur pour qu'aucun des cannaux ne dpasse 255 */
        void normalize();

        /** defini la valeur "rouge" */
        void setRed(const uint r);
        /** defini la valeur "vert" */
        void setGreen(const uint g);
        /** defini la valeur "bleu" */
        void setBlue(const uint b);

        /** defini la valeur "rouge" */
        void setRed(const float r);
        /** defini la valeur "vert" */
        void setGreen(const float g);
        /** defini la valeur "bleu" */
        void setBlue(const float b);

        /** defini la valeur "hue" (0-360) */
        void setHue(unsigned short h);
        /** defini la valeur "saturation" (0-1000) */
        void setSaturation(const unsigned short s);
        /** defini la valeur "value" */
        void setValue(const uint v);

        /** renvoie la valeur "hue" */
        unsigned short getHue() const { return iHue; }
        /** renvoie la valeur "saturation" */
        unsigned short getSaturation() const { return iSaturation; }
        /** renvoie la valeur "value" */
        uint getValue() const { return iValue; }

        /** initialise a partir des donnes au format dpendant de la librairie wxWidget */
        void initFrom(const wxColour * colour);
        /** initialise a partir des donnes au format dpendant de la librairie wxWidget */
        void initFrom(const wxColour & colour);

        /** cre un objet de type dpendant de la lib wxWidget */
        wxColour toWxColour() const;

    protected :
        /** renvoie le ratio a utiliser pour normaliser les canaux de la couleur */
        float getNormalizeRatio() const;

        /** s'assure que la valeur RGB est definie */
        void ensureRGBIsSet();

        /** s'assure que la valeur HSV est definie */
        void ensureHSVIsSet();

    private :
        bool bRGBIsSet;
        uint iRed;
        uint iGreen;
        uint iBlue;

        bool bHSVIsSet;
        unsigned short iHue;
        unsigned short iSaturation;
        uint iValue;
};

#endif
