/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POVINIFILE_H
#define POVINIFILE_H _

#include <wx/string.h>
#include <wx/arrstr.h>

#include <map>
#include <fstream>

#include "lib/commons.h"

class TIniProfile
{
    public:
        void clear();
        void addEntry(const wxString & sKey, const wxString & sValue);
        const wxString getEntry(const wxString & sKey, uint iIdx) const;
        const wxArrayString getEntries(const wxString & sKey) const;

        bool isEmpty() const;

        void toStream(std::ostream & stream) const;
        wxString fromStream(std::istream & stream);
    private:
        typedef std::map<wxString,wxArrayString> TEntriesMap;
        TEntriesMap entriesMap;
};
typedef std::map<wxString,TIniProfile> TIniProfileMap;

class TIniFile
{
    public:
        TIniProfile defaultProfile;
        TIniProfileMap iniProfiles;

        wxArrayString getProfilesList() const;

        void clear();

        void toStream(std::ostream & stream) const;
        void fromStream(std::istream & stream);
};

#endif
