/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "lib/lib_md5.h"

#include "lib/md5/md5.hpp"
#include "lib/md5/checksumutil.hpp"


namespace libmd5
{
    /**
     * calcule la somme MD5 pour un fichier
     * @param sFullPath chemin absolu du fichier a sommer
     * @param sMD5Sum variable ou mettre la somme MD5
     * @return true en cas de succes, false autrement
     */
    bool computeFile(const wxString & sFullPath, wxString & sMD5Sum)
    {
        MD5 myMD5;
        ChecksumFileCalculator md5Calculator(&myMD5);
        return md5Calculator.calculate(sFullPath,sMD5Sum) == ChecksumCalculator::Ok;
    }

    /**
     * calcule la somme MD5 pour une chaine de caracteres
     * @param sBuffer donnees a sommer
     * @param sMD5Sum variable ou mettre la somme MD5
     * @return true en cas de succes, false autrement
     */
    bool computeString(const wxString & sBuffer, wxString & sMD5Sum)
    {
        MD5 myMD5;
        ChecksumStringCalculator md5Calculator(&myMD5);
        return md5Calculator.calculate(sBuffer,sMD5Sum) == ChecksumCalculator::Ok;
    }
}

