/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _LIBSTRING_H_
#define _LIBSTRING_H_

#include "lib/commons.h"
#include <string>
#include <deque>
#include <set>
#include <wx/string.h>

/** compte le nombre d'occurences d'un caract�e dans une chaine */
uint countChar(const char * sz, char c);

/** converti un entier en chaine de caract�es */
std::string convertIntToString(int i);

/** Transforme une chaine UTF8 en une chaine iso8859-1 */
std::string UTF8Decode(const std::string & s);
/** Transforme une chaine iso8859-1 en une chaine UTF8 */
std::string UTF8Encode(const std::string & s);

wxString ISO2WX(const char * sz);
std::string WX2ISO(const wxString & s);

wxString UTF82WX(const char * sz);
std::string WX2UTF8(const wxString & s);

/** trim la chaine et renvoie sa propre rfrence */
std::string & trim(std::string & s);

/** une liste de chaines de caractres */
class TStringList : public std::deque<wxString>
{
    public:
        iterator find(const wxString & s) { return this->find(s,this->begin()); }
        iterator find(const wxString & s, const iterator & from);
        const_iterator find(const wxString & s) const { return this->find(s,this->begin()); }
        const_iterator find(const wxString & s, const const_iterator & from) const;
};

typedef std::set<wxString> TStringSet;

#endif
