/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "lib_string.h"

#include <stdio.h>
#include "lib/lib_logging.h"
#include <wx/strconv.h>
#include <wx/intl.h>

uint countChar(const char * sz, char c)
{
    uint iCount = 0;
    uint iPos = 0;
    while(sz[iPos])
    {
        if(sz[iPos] == c) iCount++;
        iPos++;
    }
    return iCount;
}

std::string convertIntToString(int i)
{
    char szBuff[20];
    sprintf(szBuff,"%d",i);

    return std::string(szBuff);
}

/** Transforme une chaine UTF8 en une chaine iso8859-1 */
std::string UTF8Decode(const std::string & sSrc)
{
    std::string sDst;
    unsigned char c;
    int iLeftToDo = sSrc.length();
    const char * s = sSrc.c_str();

    // cette partie de code a ete adaptee d'apres la copie du code source de PHP (xml_utf8_decode)
    while (iLeftToDo)
    {
        c = (unsigned char)(*s);
        if (c >= 0xf0) /* four bytes encoded, 21 bits */
        {
            c = ((s[0]&7)<<18) | ((s[1]&63)<<12) | ((s[2]&63)<<6) | (s[3]&63);
            s += 4;
            iLeftToDo -= 4;
        }
        else if (c >= 0xe0) /* three bytes encoded, 16 bits */
        {
            c = ((s[0]&63)<<12) | ((s[1]&63)<<6) | (s[2]&63);
            s += 3;
            iLeftToDo -= 3;
        }
        else if (c >= 0xc0) /* two bytes encoded, 11 bits */
        {
            c = ((s[0]&63)<<6) | (s[1]&63);
            s += 2;
            iLeftToDo -= 2;
        }
        else
        {
            s++;
            iLeftToDo--;
        }
        sDst += c;
    }

    return sDst;
}

/** Transforme une chaine iso8859-1 en une chaine UTF8 */
std::string UTF8Encode(const std::string & sSrc)
{
    std::string sDst;
    unsigned char c;
    int iLeftToDo = sSrc.length();
    const char * s = sSrc.c_str();

    // cette partie de code a ��adapt� apr� copie du code source de PHP (xml_utf8_encode)
    while (iLeftToDo > 0)
    {
        c = (unsigned char)(*s);
        if (c < 0x80)
        {
            sDst += c;
        }
        else /* always true warning __ if (c < 0x800) */
        {
            sDst += (0xc0 | (c >> 6));
            sDst += (0x80 | (c & 0x3f));
        }
        // on ne prend pas en compte ce qui pourrait etre supp�ieur a 255 car on sait qu'on aurra pas plus avec l'iso8859-1
        iLeftToDo--;
        s++;
    }

    return sDst;
}

wxString ISO2WX(const char * sz)
{
    std::string sEncodingBuffer;
    if(wxFONTENCODING_UTF8 == wxLocale::GetSystemEncoding())
    {
        sEncodingBuffer = UTF8Encode(sz);
        sz = sEncodingBuffer.c_str();
    }

    return wxString(sz,wxConvLocal);
}

std::string WX2ISO(const wxString & s)
{
    if(wxFONTENCODING_UTF8 == wxLocale::GetSystemEncoding())
        return UTF8Decode((const char *)s.fn_str());
    else
        return std::string((const char *)s.fn_str());
}


wxString UTF82WX(const char * sz)
{
    int iStrLen = strlen(sz);
    char out[iStrLen+2];
    if(wxFONTENCODING_UTF8 == wxLocale::GetSystemEncoding())
        strcpy(out,sz);
    else
    {
        // encodage en iso
        out[0] = 0;

        char szUTF8Stack[5];
        int iUTF8Size = 0;
        int iUTF8Pos = 0;

        int j = 0;
        for(int i = 0; i < iStrLen ; i++)
        {
            char c = sz[i];
            if(!(c & 128)) // caractre "normal"
            {
                out[j] = c;
                j++;
                continue;
            }

            if(c & 64)
            {
                // premier octet d'un caractre UTF8

                szUTF8Stack[0] = c;
                iUTF8Pos = 1;
                szUTF8Stack[iUTF8Pos] = 0;

                iUTF8Size = 2;
                if(c & 32)
                {
                    iUTF8Size++;
                    if(c & 16)
                        iUTF8Size++;
                }
            }
            else
            {
                szUTF8Stack[iUTF8Pos] = c;
                iUTF8Pos++;
                szUTF8Stack[iUTF8Pos] = 0;

                if(iUTF8Pos == iUTF8Size)
                {
                    out[j] = UTF8Decode(szUTF8Stack)[0];
                    j++;
                }
            }
        }
        out[j] = 0;
    }
    return wxString(out,wxConvLocal);
}

std::string WX2UTF8(const wxString & s)
{
    if(wxFONTENCODING_UTF8 == wxLocale::GetSystemEncoding())
        return std::string((const char *)s.fn_str());
    else
        return std::string(UTF8Encode((const char *)s.fn_str()));
}

std::string & trim(std::string & s)
{
    uint iNonSpace = 0;
    while(iNonSpace < s.length() && isspace(s[iNonSpace]))
        iNonSpace++;
    s.erase(0,iNonSpace);
    iNonSpace = s.length() - 1;
    while(iNonSpace >= 0 && isspace(s[iNonSpace]))
        iNonSpace--;
    s.erase(iNonSpace+1,s.length());

    return s;
}

TStringList::iterator TStringList::find(const wxString & s, const TStringList::iterator & from)
{
    iterator it = from;
    while(it != this->end())
    {
        if( (*it) == s )
            break;
        it++;
    }
    return it;
}

TStringList::const_iterator TStringList::find(const wxString & s, const const_iterator & from) const
{
    const_iterator it = from;
    while(it != this->end())
    {
        if( (*it) == s )
            break;
        it++;
    }
    return it;
}

