/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _LIBLOGGING_H_
#define _LIBLOGGING_H_


#include "lib/commons.h"
#include "lib/Logger.h"

/**
 * Macro dont l'objectif est de simplifier l'envoi d'un message de debug
 */
#define LOG_DEBUG(MSG)  logging::Logger::logMessage(__FILE__,__LINE__,(MSG),logging::_DEBUG_)

/**
 * Macro dont l'objectif est de simplifier l'envoi d'un message du niveau sp�cifi�
 */
#define LOG_MESSAGE(MSG,LVL)  logging::Logger::logMessage(__FILE__,__LINE__,(MSG),(LVL))


#endif

