/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "StdErrLogFormater.h"
#include "LoggingLevel.h"

#include <iostream>
#include <time.h>
#include <string.h>

namespace logging
{
    StdErrLogFormater::StdErrLogFormater(){}
    StdErrLogFormater::~StdErrLogFormater()
    {
        if(this == StdErrLogFormater::instance)
            StdErrLogFormater::instance = NULL;
    }

    StdErrLogFormater * StdErrLogFormater::getInstance()
    {
        if(StdErrLogFormater::instance == NULL)
            StdErrLogFormater::instance = new StdErrLogFormater();
        return StdErrLogFormater::instance;
    }

    /** enregistre le message prformat sur la sortie standard */
    void StdErrLogFormater::storeFormatedMessage(std::string sMessage)
    {
        std::cerr << sMessage << std::endl;
    }

    StdErrLogFormater * StdErrLogFormater::instance = NULL;
}
