/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _LIBLOGGING_LOGGER_H_
#define _LIBLOGGING_LOGGER_H_


#include <string>
#include <map>

#include "lib/commons.h"
#include "lib/lib_string.h"

#include "lib/LoggingLevel.h"
#include "lib/LogMessage.h"
#include "lib/LoggingFormater.h"

namespace logging
{
    /**
     * @short Gestionnaire de messages de log
     * @author Thierry CHARLES <thierry@les-charles.net>
     * @version 0.1
     */
    class Logger
    {
        public :
            /** logue un message */
            static void logMessage(const char * szFileName, const int iLine, const char * szMessage, const LoggingLevel lvl);

            /** logue un message */
            static void logMessage(const char * szFileName, const int iLine, const wxString & sMessage, const LoggingLevel lvl) { logMessage(szFileName,iLine,(const char *)sMessage.fn_str(), lvl); }


        protected :
            Logger();
            virtual ~Logger();

            /** envoie le message a tous les medias du lvl donn� */
            virtual void log(const LogMessage & msg);
            /** renvoie l'instance statique du logger */
            static Logger * getInstance();

        private :
            /** instance statique du logger */
            static Logger * instance;

            typedef std::multimap<LoggingLevel,LoggingFormater *> TFormatersMap;
            typedef TFormatersMap::iterator TFormatersMapIt;
            /** map des formateurs par niveau de log */
            TFormatersMap formaters;

    };
}

#endif
