/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "Logger.h"

#include "StdOutLogFormater.h"
#include "StdErrLogFormater.h"


namespace logging
{

    // constructeur
    Logger::Logger()
    {
        this->formaters.insert(TFormatersMap::value_type(_DEBUG_,StdErrLogFormater::getInstance()));
        this->formaters.insert(TFormatersMap::value_type(_INFO_,StdOutLogFormater::getInstance()));
        this->formaters.insert(TFormatersMap::value_type(_WARN_,StdOutLogFormater::getInstance()));
        this->formaters.insert(TFormatersMap::value_type(_ERROR_,StdErrLogFormater::getInstance()));
        this->formaters.insert(TFormatersMap::value_type(_FATAL_,StdErrLogFormater::getInstance()));
    }

    //destructeur
    Logger::~Logger()
    {
    }


    void Logger::log(const LogMessage & msg)
    {
        // dispatcher le message
        TFormatersMapIt itC = this->formaters.lower_bound(msg.lvl);
        TFormatersMapIt itE = this->formaters.upper_bound(msg.lvl);

        while (itC != itE)
        {
            (*itC).second->formatMessage(msg);
            itC++;
        }
    }

    Logger * Logger::getInstance()
    {
        if(Logger::instance == NULL)
            Logger::instance = new Logger();
        return Logger::instance;
    }


    void Logger::logMessage(const char * szFileName, const int iLine, const char * szMessage, const LoggingLevel lvl)
    {
        LogMessage msg(szFileName,iLine,szMessage,lvl);
        Logger::getInstance()->log(msg);
    }

    Logger * Logger::instance = NULL;

}
