/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _LIBLOGGING_FLATTEXTLOGFORMATER_H_
#define _LIBLOGGING_FLATTEXTLOGFORMATER_H_

#include "lib/commons.h"
#include "lib/LoggingFormater.h"
#include <string>

namespace logging
{
    /**
     * impl�mentation de la la classe LoggingFormater
     * Cette impl�mentation formate le message et l'affiche sur la sortie standard
     *
     * @short Formateur de log sur la sortie Standard
     * @author Thierry CHARLES <thierry@les-charles.net>
     * @version 0.1
     */
    class FlatTextLogFormater : public LoggingFormater
    {
        public :
            FlatTextLogFormater(){}
            virtual ~FlatTextLogFormater(){}

            /** formate le message puis fait appel a storeFormatedMessage */
            virtual void formatMessage(const LogMessage & msg);

            /** enregistre le message pr�format� sur le support */
            virtual void storeFormatedMessage(std::string sMessage) = 0;
    };
}
#endif
