/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "FlatTextLogFormater.h"
#include "LoggingLevel.h"

#include <time.h>
#include <string.h>
#include "lib_string.h"
#include <string>

namespace logging
{
    void FlatTextLogFormater::formatMessage(const LogMessage & msg)
    {
        time_t t = time(NULL);
        struct tm * currentTime = localtime(&t);
        char szTime[256];
        sprintf(szTime,"%02d/%02d/%4d %02d:%02d:%02d",currentTime->tm_mday, currentTime->tm_mon+1, currentTime->tm_year+1900, currentTime->tm_hour,currentTime->tm_min, currentTime->tm_sec);
        std::string sMessage(szTime);
        sMessage = sMessage + "|" + msg.szFileName + ":" + convertIntToString(msg.iLine) + "|" + LoggingLevelToSz(msg.lvl) + "|" + msg.szMessage;

        this->storeFormatedMessage(sMessage);
    }
}
