/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "toolbar_panelelt.h"

#include "components/codeeditor/tcodeeditor.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/framework/tmainwindow.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"
#include "components/stdgui/tgenbutton.h"
#include "xpe_components/editor/editor_panelelement.h"

#include "lib/tcolor.h"
#include "lib/lib_string.h"
#include "lib/lib_logging.h"

#include "bmp_id.h"

ToolbarPanelElement::ToolbarPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT(""), wxT("")),
    contentPanel(NULL)
{
    this->setExtensivity(0);
    this->setAlwaysVisible( true );
}

ToolbarPanelElement::~ToolbarPanelElement()
{
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * ToolbarPanelElement::buildContentPanel()
{
    TPanel * panel = new TPanel(this->getOwner()->getContentPanel());
    this->contentPanel = panel;
    wxSizer * sizer = new wxBoxSizer( this->getOwner()->getOrient() == TApplicationPanel::Horizontal ? wxHORIZONTAL : wxVERTICAL );
    panel->SetSizer(sizer);

    int iLastAdded = -1;

    TButtonsInfoList::iterator it = this->infoList.begin();
    while(it != this->infoList.end())
    {
        iLastAdded = (*it).iButtonID;
        if( (*it).iButtonID == -1 )
        {
            sizer->AddSpacer(5);
            it++;
            continue;
        }
        TGenButton * btn = new TGenButton(panel);
        btn->setText( (*it).sLabel );
        btn->setBitmap((*it).bmp);
        btn->SetToolTip((*it).sTooltip);
        btn->setToggleable( (*it).bTogglable );
        btn->addButtonListener( this );
        sizer->Add(btn,0,wxEXPAND);

        (*it).btn = btn;
        this->btnsMap[btn] = &(*it);

        it++;
    }

     // si le dernier element n'est pas un separateur, on en met un d'office pour que la barre suivante ne soit pas collee
    if(iLastAdded != -1)
        sizer->AddSpacer(5);

    sizer->AddStretchSpacer(1);

    return panel;
}

void ToolbarPanelElement::buttonActivated(TGenButton * btn)
{
    TButtonsMap::iterator it = this->btnsMap.find(btn);
    if(it != this->btnsMap.end())
    {
        this->buttonClicked( (*it).second->iButtonID, btn->isToggled() );
    }
}

void ToolbarPanelElement::buttonToggled(TGenButton * btn)
{
    TButtonsMap::iterator it = this->btnsMap.find(btn);
    if(it != this->btnsMap.end())
    {
        this->buttonClicked( (*it).second->iButtonID, btn->isToggled() );
    }
}

/** ajoute un bouton  la barre d'outils. La barre se construit de gauche  droite ou de haut en bas selon l'orientation du panneau pre. */
void ToolbarPanelElement::addButton(int iButtonID, const TBitmap * bmp, const wxString & sLabel, const wxString & sTooltip, bool bTogglable)
{
    TButtonInfo info;
    info.iButtonID = iButtonID;
    info.bmp = bmp;
    info.sLabel = sLabel;
    info.sTooltip = sTooltip;
    info.bTogglable = bTogglable;

    this->infoList.push_back(info);
}

/** ajoute un sparateur  la barre d'outils. La barre se construit de gauche  droite ou de haut en bas selon l'orientation du panneau pre. */
void ToolbarPanelElement::addSeparator()
{
    TButtonInfo info;
    info.iButtonID = -1;

    this->infoList.push_back(info);
}
