/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TLISTCTRL_H_
#define _STDGUI_TLISTCTRL_H_

#include <wx/listctrl.h>

#include "lib/commons.h"
/**
 * @short Un composant de liste
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TListCtrl : public wxListCtrl
{
    public :
        /** voir doc de wxListCtrl */
        TListCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxLC_ICON, const wxValidator& validator = wxDefaultValidator, const wxString& name = wxListCtrlNameStr) : wxListCtrl(parent, id, pos, size, style, validator, name) {}

        virtual ~TListCtrl(){}

        /**
         * Gets information about the item. See wxListCtrl::SetItem for more information.
         * You must call info.SetId() to the ID of item you're interested in before calling this method.
         */
        virtual bool GetItem(wxListItem& info) const { info.SetMask(-1); return wxListCtrl::GetItem(info); }
};

#endif // _STDGUI_TLISTCTRL_H_
